# The Efcacy of Multi‑component Positive Psychology Interventions: A Systematic Review and Meta‑analysis of Randomized Controlled Trials

Tom Hendriks1 $\textcircled { \scriptsize { 1 } }$ · Marijke Schotanus‑Dijkstra2  · Aabidien Hassankhan1  · Joop de Jong3  · Ernst Bohlmeijer2

Published online: 11 February 2019   
$\circledcirc$ Springer Nature B.V. 2019

# Abstract

Recently, we see a sharp increase in the number of multi-component positive psychology interventions (MPPIs). The aim of the current study is to examine the efcacy of MPPIs, through a systematic review and meta-analysis. We included 50 randomized controlled trials that were published in 51 articles between 1998 and August 2018. We found standardized mean diferences of Hedges’ $g { = } 0 . 3 4$ for subjective well-being, Hedges’ $g = 0 . 3 9$ for psychological well-being, indicating small to moderate efects, and Hedges’ $g = 0 . 2 9$ for depression, and Hedges’ $g = 0 . 3 5$ for anxiety and stress, indicating small efects. Removing outliers led to a considerable decrease in efect sizes for subjective well-being and depression, a slight decrease for psychological well-being, and a strong increase in the efect size for stress. Removing low quality studies led to a considerable decrease in the efect sizes for subjective well-being, psychological well-being, and depression, and a slight decrease for anxiety, but a strong increase for stress. Moderator analyses only showed a signifcant efect for study quality, showing larger efect sizes for low quality studies compared to studies of moderate and high quality. In addition, a larger efect size for anxiety was found in studies from non-Western countries compared to studies from Western countries. In sum, this systematic review and meta-analysis found evidence for the efcacy of MPPIs in improving mental health. We conclude that MPPIs have a small efect on subjective wellbeing and depression, and a small to moderate efect on psychological well-being. In addition, they may have a small to moderate efect on anxiety and a moderate efect on stress, but defnite conclusions of the efects of MPPIs on these outcomes cannot me made due to the limited number of studies. Further well-conducted research among diverse populations is necessary to strengthen claims on the efcacy of MPPIs.

Keywords Positive psychology $\cdot$ Well-being $\cdot$ Positive mental health $\cdot$ Multicomponent Randomized controlled trials $\cdot$ Meta-analysis

# 1 Introduction

The positive psychology movement intended to redirect the course of psychological research: away from a focus on pathology, diseases and defcits, and towards the study of human strengths, fourishing and the optimal functioning of individuals, groups, and institutions (Gable and Haidt 2005; Seligman and Csikszentmihalyi 2000; Sheldon and King 2001). Since its inauguration in 1998, the movement has made a considerable impact on the scientifc community, with an exponential growth of publications (Donaldson et al. 2015; Hart and Sasso 2011; Hendriks et  al. 2018b; Kim et  al. 2018; Rusk and Waters 2013). Positive psychology builds on the ideas of humanistic psychology, but employs state-of the art-research methods to ensure scientifc rigor (Froh 2004; Sheldon and Kasser 2001). Studies that investigate the efcacy of so-called positive psychology interventions (PPIs), are a cornerstone of psychological inquiry.

There has been much discussion on the defnition of PPIs. A broad defnition was introduced by Sin and Lyubomirsky (2009), who defned PPIs as all interventions that aim at increasing positive feelings, behaviors, and cognitions. Narrower defnitions were suggested by Bolier et  al. (2013b), who added that these interventions ‘should have been explicitly developed in line with the theoretical tradition of positive psychology’ (Bolier et  al. (2013b) and Parks and Biswas-Diener (2013), who suggested that an intervention can only be regarded as a PPI if sufcient empirical evidence exists suggesting signifcant efects for the intervention (Parks and Biswas-Diener 2013). Schueller and Parks (2014) argued that in addition to the (positive) aim of an intervention, the pathways through which the interventions operate is a second essential component when deciding if an intervention can be considered as a PPI. Building on these suggestions, we defne positive psychology interventions as interventions aiming at increasing positive feelings, behaviors, and cognitions, while also using theoretically and empirically based pathways or strategies to increase well-being.

To date, two meta-analyses have been published that examined the overall efcacy of PPIs. The frst meta-analysis included 51 controlled studies and found large efects for enhanced well-being $( r { = } 0 . 2 9 $ , $d \cong 0 . 6 1$ ) and depressive symptoms $_ { r = 0 . 3 1 }$ , $d \cong 0 . 6 5$ ) (Sin and Lyubomirsky 2009). The second meta-analysis included 39 randomized controlled trials (RCTs) (Bolier et  al. (2013a, b) and reported small efect sizes $\scriptstyle ( d = 0 . 3 4 )$ for subjective well-being, psychological well-being $\scriptstyle ( d = 0 . 2 0 )$ ), and depression $\scriptstyle { \mathcal { A } } = 0 . 2 0$ ). Bolier et al. (2013a, b) argued that the efect sizes in the meta-analysis by Sin and Lyubomirsky might be overestimated, due to the application of less stricter inclusion criteria, for example by including non-randomized controlled trials and studies in the feld of mindfulness and life review therapy.

# 1.1 Multi‑component Positive Psychology Interventions (MPPIs)

A diferentiation can be made between single component intervention studies and multicomponent intervention studies. Single component intervention studies usually consist of one or more positive psychology activities targeting one component of well-being. For example, studies on the efects of gratitude interventions (DeSteno et  al. 2015; Digdon and Koble 2011; Isik and Erguner-Tekinalp 2017; Lau and Cheng 2011), engaging in acts of kindness (Alden and Trew 2013; Buchanan and Bardi 2010; O’Connell et  al. 2016), and strengths-based interventions (Proyer et  al. 2015; Toback et  al. 2016). MPPIs may be considered as interventions that contain a variety of evidence-based individual exercises and targeting two or more theoretically relevant hedonic and eudaimonic well-being components, that are conducted within an integral program. Examples of theoretical components are the components of the PERMA-model (i.e. positive emotions, engagement, relationships, meaning, and accomplishment) by Seligman (2018), and the components of the Synergetic Change Model (i.e. emotions, goals and habits, virtues and relationships, comprehension and coping, attention and awareness), which was developed by Rusk et al. (2018).

# 1.2 Present Study

Over the years, there is a growing body of research on the efcacy of MPPIs. The primary aim of this meta-analysis is to examine the efcacy of MPPIs on well-being and distress in both the general public and in clinical populations. MPPIs contain a wide variety of positive activities that target diferent domains of mental well-being. Consequently, we expect that MPPIs have larger efects than have been found in prior meta-analyses of mainly single component interventions, both at post-treatment and at follow-up measurements. The secondary aims were to identify moderators that may infuence the relation between the intervention and the outcomes, determine the quality of the studies, and examine potential publication bias.

# 2 Method

The Preferred Reporting Items for Systematic Reviews and Meta-Analyses (PRISMA) guidelines for systematic reviews and meta-analyses (Moher et al. 2010) and the recommendations of the Cochrane Back Review group (Higgins et al. 2011) were followed in the planning and the implementation of the meta-analysis.

# 2.1 Search Strategy

A systematic literature search was conducted in the following three databases: PubMed, PsycINFO and Scopus, from 1998 to August 2018. The last run was conducted on the 31st of July 2018. The search was conducted by the frst and third author. The databases were searched with the following terms: positive psychology, well-being, happiness, happy, fourishing, life satisfaction, satisfaction with, optimism, gratitude, strengths, forgiveness, compassion and random. The search strings were adapted to the according database (see the “Appendix 1”). Additionally, reference lists of four meta-analyses (Bolier et al. 2013a, b; Chakhssi et al. 2018; Dickens 2017; Sin and Lyubomirsky 2009) and six review articles on PPIs (Casellas-Grau et al. 2014; Macaskill 2016; Rashid 2015; Sutipan et al. 2016; Walsh et al. 2017; Woodworth et al. 2016) were checked. Several experts in the feld of positive psychology also suggested additional studies.

# 2.2 Selection of Studies

After removal of duplicates, titles and abstracts were screened by two reviewers (frst and second author). Full texts of potentially relevant articles were assessed. Studies were included based on the following criteria: (1) studies were RCTs; (2) studies were administered to adults in clinical and non-clinical populations; (3) interventions were comprised of at least two positive activities and two modules that were explicitly based on strategies aiming at hedonic and eudaimonic well-being components and conducted within an integral program; (4) studies were published in peer reviewed journals; (5) studies used outcome measures to examine the efects on subjective and psychological well-being, depression, anxiety, and stress. Excluded were: (1) cluster randomized controlled trials; (2) interventions that were primarily focused on one component such as mindfulness-based therapies, Acceptance and Commitment therapy, loving kindness meditation, forgiveness therapy, compassion focused therapy, hope therapy, and self-management; (3) studies that did not provide sufcient data to calculate post-treatment efect sizes per condition and the corresponding author was unable to provide the necessary data upon request; (4) studies that were published in book chapters, dissertations, and studies in grey literature; (5) articles that were not published in English.

# 2.3 Data Extraction

The frst author performed the data extraction, which was then verifed by the second author. Any disagreements were resolved by consensus and through consultation with the last author. The following data was gathered: authors, year of publication, country of origin, condition of participants (clinical or non-clinical), intervention type (PPI or PPI plus other intervention type), delivery form (group-based, individual therapy or self-help), description of control group (active or non-active), number of sessions, duration of session period, follow-up assessment, number or participants per condition at post-test level, mean age and standard deviation of participants, percentage of female participants, retention rate at post-test level per condition, type of outcome and used questionnaires. Self-help refers to interventions through self-help books or instructions by email, and web-based self-help applications. Individual therapy refers to an intervention that was delivered by therapists during face-to-face sessions. Following Gosling et al. (2010), we classifed North America, Western Europe, Israel, Australia, and New Zealand as Western-countries, other countries were classifed as non-Western. For the meta-analyses, we extracted means and standard deviations at post-test. In case of insufcient data or unclear reporting, we contacted the authors through e-mail. In total, ffteen authors were contacted, of which eight provided sufcient additional data to be able to include the study in our analysis.

# 2.4 Quality Assessment

The frst and third author independently assessed the quality of each study using the Cochrane Collaboration’s tool for assessing risk of bias in RCTs (Higgins et al. 2011) with six criteria: (1) sequence generation: was there a detailed description of method that was used to generate the allocation sequences (e.g. referring to random numbers, using a computer with random number generator, coin tossing, drawing of lots); (2) allocation concealment: could the processes of enrolling of participants not be foreseen by participants or investigators, for example through the use of numbered, opaque, sealed envelopes or central allocation (web-based applications); (3) were outcome measures blinded, administered by an independent person or via online assessment; (4) was there a description of the withdrawals/drop-outs; (5) was a power analysis carried out or was the group size per condition larger than 50; (6) was an intention-to-treat analysis conducted, or were there zero drop-outs. One point was appointed for each criterion met. The quality of a study was assessed as ‘high’ when a minimum of fve criteria were met, ‘moderate’ when three to four criteria were met, and ‘low’ when less than three criteria were met. Consensus between the two reviewers was reached through discussion.

# 2.5 Statistical Analyses

Data analyses were performed with the program Comprehensive Meta-Analysis (CMA, version 3.3.070). We used the means, standard deviations, and sample sizes for each study, to calculate the efect size using dichotomous outcomes. For each comparison between a PPI and a control group, Hedges’ $g$ efect sizes were calculated to assess the betweengroup diferences at post-test. These efect sizes were calculated by subtracting the average score of the PPI group from the average score of the comparison group (both at post-test) and dividing the result by the pooled standard deviations obtained from the two groups. We used Hedges’ $g$ because this efect size measure is more accurate than Cohen’s $d$ when study sample sizes of the studies are small (Cuijpers 2016), which is the case in more than half of the studies we included. Similarly to Cohen’s $d$ , Hedges’ $g$ efect sizes of 0–0.32 can be considered as small, efect sizes of 0.33–0.55 as moderate, and efect sizes of 0.56–1.2 as large (Lipsey and Wilson 1993). In the calculation of efect sizes for depression, stress, and anxiety we used the scores on instruments that explicitly measured these outcomes. For subjective and psychological well-being, we also used scores from instruments related to these constructs of well-being. See “Appendix 1” for detailed information on the used instruments per outcome. If more than one measure was used for a particular outcome in one study, the pooled efect size was calculated. Thus, each study provided only one efect size for all outcomes. When available, we computed between-group efect sizes (Hedges’ g) for follow-up diferences. Follow-up efects were calculated if there was a minimum of fve studies per outcome.

Due to the diverse populations, we expected considerable heterogeneity. Therefore, we performed the meta-analysis using a random efects model, with a $9 5 \%$ confdence interval and using a two-tailed test. Separate meta-analyses were performed for subjective well-being, psychological well-being, depression, anxiety, and stress. Forest plots of post between-group efect sizes were produced for each outcome variable, both with and without outliers. We considered a study as an outlier when its $9 5 \%$ confdence interval (CI) was outside the $9 5 \%$ CI of the overall mean efect size (on either side). We tested for statistical heterogeneity between studies using the $\mathrm { I } ^ { 2 }$ statistics, a measure of how much variance between studies can be attributed to diferences between studies, beyond the expected chance (Higgins and Green 2011). We used the $\mathrm { I } ^ { 2 }$ statistic to estimate the percentage of heterogeneity across the studies not attributable to random sample error alone. A value of $0 \%$ indicated no heterogeneity. Values of 25, 50, and $7 5 \%$ refected low, moderate, and high degrees of heterogeneity, respectively (Higgins and Thompson 2002). Signifcant heterogeneity was indicated by a signifcant Q-statistic $( p < 0 . 0 5 )$ , meaning that one or more variables were present that moderated the observed efect size.

Exploratory subgroup analyses were conducted to examine the moderating efects of the following variables: (1) population types: clinical and non-clinical; (2) intervention: MPPI and MPPI combined with another therapy form; (3) delivery mode: group intervention, individual therapy, and self-help; (4) control group: active and non-active controls; (5) number of sessions: eight or less, more than eight; (6) duration of program: 8 weeks or less, more than 8 weeks; (7) quality rating: low quality (score of 0, 1, 2), moderate quality (score of 3, 4), high quality (score of 5, 6); (8) region: Western or non-Western.

We assessed publication bias in the following ways. First, we created a funnel plot by plotting the overall mean efect size against study size. Absence of publication bias is present when there is a symmetric distribution of studies around the efect size, while a higher concentration of studies on one side of the efect size than on the other indicates publication bias (Sterne et al. 2008). Second, we calculated a fail-safe N, a formal test of funnel plot asymmetry, for each analysis. This fail-safe N indicates the number of unpublished non-signifcant studies that would be required to lower the overall efect size below signifcance (Egger et al. 1997; Orwin 1983). Findings were considered robust if the failsafe $\mathrm { N } \geq 5 k + 1 0$ , where $k$ is the number of studies (Rosenberg 2005). Third, we used the trim- and-fll method (Duval and Tweedie 2000). This procedure imputes the efect sizes of missing studies and produces an adjusted efect size accounting for the missing studies.

# 3 Results

# 3.1 Study Selection

In total we found 8532 records: 2203 from PubMed, 4155 from PsycINFO, 19,610 from Scopus, 260 from searching reference lists and four studies were suggested by third parties. After removal of duplicates, 7662 records remained for screening. Of these, we discarded 7338 articles based on screening title and abstract that did not meet the inclusion criteria. We then assessed 324 full-text articles. Finally, 51 articles with a total of 50 studies met the inclusion criteria and were included in the meta-analysis. Results from one study was published in two articles (Asl et al. 2014, 2016), and two articles reported outcomes of two studies (Ivtzan et al. 2018; Seligman et al. 2006). Figure 1 displays the selection process in a fow diagram.

# 3.2 Study Characteristics

The studies included a total of 6141 participants at post measurement level. Sample sizes of the MPPI condition ranged from 8 to 450, with a median of 35. Twenty-four studies $(4 8 \% )$ were conducted among clinical populations and 26 among non-clinical populations $( 5 2 \% )$ . Delivery modes were group-based $\scriptstyle ( n = 2 8 , 4 3 \% )$ , through self-help books/instructions by e-mail ( $n = 1 9$ , $4 1 \%$ ) or online/web-based self-help applications $\mathrm { \Delta } n = 1 6$ , $8 4 \%$ ), and individual therapy $( n = 3 , 6 \% )$ . Twenty-three control conditions $(46 \% )$ were active control groups (placebo, $n = 8$ , $1 6 \%$ ; cognitive behavioral therapy, $n = 6$ , $1 2 \%$ ; treatment as usual, $n = 6$ , $1 2 \%$ ; mindfulness meditation, $n = 2$ , $4 \%$ and dialectical behavioral therapy, $n = 1$ , $2 \%$ ). Twenty-seven control conditions $( 5 4 \% )$ were non-active control groups (wait-list, $n = 1 8$ , $3 6 \%$ ; no intervention, $n = 9$ , $1 8 \%$ ). The number of sessions varied between 1 and 28, with an average of 8.6 sessions $\mathrm { \langle S D } { = } 5 . 7 3$ ). The duration of the MPPI varied between 1 day and 22 weeks, with an average of 8.1 weeks $( \mathrm { S D } = 3 . 8 8 $ ). Two studies did not report the duration period. Twenty-two $(44 \% )$ studies reported follow-up efects. The mean age of the participants in the intervention groups $( n = 4 2 )$ ) was 39.7 years $( \mathrm { S D } = 1 3 . 0 7 ,$ ). The average retention rate was $7 4 \%$ for the MPPI groups $( n = 4 8 )$ , and $7 9 \%$ for the control groups $( n = 4 8 )$ . The average percentage of female participants in the intervention groups was $6 7 \%$ $( n = 4 4 )$ ). It should be noted that not all studies reported the exact age, retention rate or number of female participants. The main characteristics of the studies are presented in Table 1.

![](images/7508954720dbb0e24c2023e77ec1bf4aea56de4f51abc2744f3c5f169946cb9a.jpg)  
Fig. 1 Results of literature search and selection process

# 3.3 Study Measures

Outcomes that were classifed as subjective well-being included happiness, emotional and subjective well-being, satisfaction with life, positive afect, quality of life, and well-being. Outcomes that were classifed as psychological well-being included fourishing, authentic living, personal growth, meaning, autonomy, (work) engagement, psychological capital, environmental well-being, positive relations, purpose in life, and self-acceptance. All studies included at least one measure of a particular outcome.

In total, we found 39 studies that measured subjective well-being, 24 studies measured psychological well-being, 31 studies measured depression, 11 studies measured anxiety, and eight studies measured stress. An overview of the questionnaires that were used to measure the outcomes is shown in “Appendix $3 ^ { \circ }$ . Five studies included two measures for subjective well-being, which were pooled by the authors of the current meta-analysis (Cheung et al. 2017; Gelfn et al. 2018; Hausmann et al. 2017; Hendriks 2018; Mohammadi et al. 2018). Six studies (Chaves et al. 2017; Dyrbye et al. 2016; Ivtzan et al. 2016; Mohammadi et al. 2018; Myers et al. 2017; Rogerson et al. 2016) included two or more measures for psychological well-being that were pooled.

<html><body><table><tr><td>First author,year,Condition ofIntervention country</td><td>participants</td><td>type</td><td>Delivery</td><td>Control group</td><td>Sessions, duration</td><td>Follow up</td><td>N post</td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>Antoine, 2018, France</td><td>Healthy adults</td><td>PPI</td><td>Self-help</td><td>NI</td><td>6,6 weeks</td><td></td><td>Ne=45 Nc=94</td><td>37.0</td><td>69.5b</td><td>76% 63%</td><td>Dep: BDI, Anx: STAI</td></tr><tr><td>Asgharipoor, 2012,Iran</td><td>Patients with major depression</td><td>PPI</td><td>Group</td><td>CBT</td><td>6,12 weeks-</td><td></td><td>Ne=9 Nc=9</td><td>26.4 (5.9)</td><td>72</td><td>100% 100%</td><td>SWB: OHI; PWB: SWS pwb subscale Dep: BDI;</td></tr><tr><td>Asl, 2014, 2016, Iran</td><td>Infertile women</td><td>PPI</td><td>Group</td><td>Waitlist</td><td>6,6 weeks</td><td></td><td>Ne=18 Nc=18</td><td>30.5 (5.7)</td><td>100</td><td>83% 89%</td><td>Stress: SUDS SWB: OHI Dep: BDI</td></tr><tr><td>Bolier,2013b,the Mildly Netherlands</td><td>depressed adults</td><td>PPI</td><td>Self-help: online,</td><td>Waitlist</td><td>6,9 weeks</td><td>4 months</td><td>Nc=141</td><td>Ne=14343.5 (11.7)</td><td>80</td><td>66% 84%</td><td>SWB: MHC-SF ewb subscale, PWB: MHC- SF pwb sub- scale,Dep: CES-D, Anx:</td></tr><tr><td>Cantarella, 2017, Italy</td><td>Elderly</td><td>PPI</td><td>Group</td><td>Placebo</td><td>6,8 weeks</td><td></td><td>Ne=16 Nc=16</td><td>69.4 (6,6)</td><td></td><td>100%</td><td>HADS-A SWB: WHO- QoL Brief, PWB: Ben- sSC</td></tr><tr><td>Carr, 2015, Ireland</td><td>Patients with major depression</td><td>PPI</td><td>Group</td><td>TAU</td><td>20, 20 weeks</td><td>3 months</td><td>Ne=28 Nc=29</td><td>41.0</td><td>66</td><td>70% 73%</td><td>Dep: BDI</td></tr><tr><td>Celano,2017, USA</td><td>Patients with major depression</td><td>PPI</td><td>Self-help</td><td>CBT</td><td>6,6 weeks</td><td>6 weeks</td><td>Ne=29 Nc=29</td><td>44.0 (10.0)</td><td>69</td><td>97% 94%</td><td>SWB: PANAS Dep: QIDS-SR</td></tr><tr><td>Cerezo,2014, Spain</td><td>Women with PPI breast</td><td></td><td>Group</td><td>Waitlist</td><td>14， 14 weeks</td><td></td><td>Ne=87 Nc=88</td><td>50.0 (9.6)</td><td>100</td><td>86% 83.0%</td><td>SWB: SWLS</td></tr></table></body></html>

<html><body><table><tr><td>First author,year,Condition ofInterventionDelivery country</td><td>participants</td><td>type</td><td></td><td>Control group</td><td>Sessions, duration</td><td>Follow up</td><td>N post</td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>Chaves, 2017, Spain</td><td>Women with major depression</td><td>PPI</td><td>Group</td><td>CBT</td><td>10, 10 weeks</td><td></td><td>Ne=34 Nc=39</td><td>51.6 (10.4)</td><td>100</td><td>72% 80%</td><td>SWB: SWLS: PWB:PWBS Dep: BDI; Anx: BAI</td></tr><tr><td>Cheung,2017, USA</td><td>Women with PPI breast cancer</td><td></td><td>Group</td><td>CBT</td><td>5,5 weeks</td><td>1 months</td><td>Ne=14 Nc=13</td><td>53.4 (11.2)</td><td>100</td><td>71% 85%</td><td>SWB: DES Dep: CES-D</td></tr><tr><td>Cohn,2014, USA Adults withPPI</td><td>type 2 diabetes</td><td></td><td>Self-help: online</td><td>Placebo</td><td>8,9 weeks</td><td></td><td>Ne=25 Nc=17</td><td>54(median） 51</td><td></td><td>79%</td><td>SWB: PANAS Dep: CES-D; Stress: PSS</td></tr><tr><td>Cullen,2016,UK Adults withPPI</td><td>acquired brain injury</td><td></td><td>Individual</td><td>TAU</td><td>8,8 weeks</td><td>11 weeks</td><td>Ne=10 Nc=10</td><td>57(median） 37</td><td></td><td>71% 71%</td><td>SWB: AHI Dep, Anx, Stress: DASS-21</td></tr><tr><td>Dowlatabadi, 2016, Iran</td><td>Women with PPI breast cancer</td><td></td><td>Group</td><td>NI</td><td>10, 10 weeks</td><td></td><td>Ne=17 Nc=17</td><td>36.6 (5.5)</td><td>100</td><td>76% 81%</td><td>SWB: OHI Dep: BDI</td></tr><tr><td>Drozd, 2014a, Norway Drozd, 2014b,</td><td>Healthy adults</td><td>PPI</td><td>Self-help: online</td><td>Waitlist</td><td></td><td>13,4 weeks5 months</td><td>Nc=88</td><td>Ne=108 30.6 (8.4)</td><td>75</td><td>96% 94%</td><td>SWB: PANAS</td></tr><tr><td>Norway</td><td>HIV patients PPI with depressive symptoms</td><td></td><td>Self-help: online</td><td>Waitlist</td><td>14,5 weeks-</td><td></td><td>Ne=36 Nc=31</td><td>48.2 (9.3)</td><td>7.5</td><td>72% 94%</td><td>SWB: SWS Dep: CES-D</td></tr><tr><td>Dyrbye,2016, USA</td><td>Healthy adults</td><td>PPI</td><td>Self-help: online</td><td>NI</td><td>10, 10 weeks</td><td></td><td>Ne=145 Nc =145</td><td></td><td>32</td><td>94% 98%</td><td>SWB: Slas PWB: EWS,</td></tr></table></body></html>

<html><body><table><tr><td>First author,year,Condition of country</td><td>participants</td><td>Intervention type</td><td>Delivery</td><td>Control group</td><td>Sessions, duration</td><td>Follow up</td><td>N post</td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>Feicht, 2013, Germany</td><td>Healthy adults</td><td>PPI</td><td>Self-help: online</td><td>Waitlist</td><td>21,7 weeks4 weeks</td><td></td><td>Ne=72 Nc=57</td><td>37.2 (9.0)</td><td>69</td><td>94% 100%</td><td>SWB: VAS; PWB: FS Stress: SWSS</td></tr><tr><td>Gelfin, 2018, Israel</td><td>Healthy adults</td><td>PPI</td><td>Self-help: online</td><td>Waitlist</td><td>6,6 weeks 8,8 weeks</td><td>4 weeks</td><td>Ne=25 Nc=29 Ne=34</td><td>36.0 (10.5) (all) 20.4 (1.2)</td><td>74 (all)</td><td>51% 71%</td><td>SWB: SHI, PPI, SWLS PWB: GSE</td></tr><tr><td>Guo,2016, China Under-</td><td>graduate students</td><td>PPI</td><td>Group</td><td>NI</td><td></td><td>3 months</td><td>Nc =42</td><td></td><td>95</td><td>81% 98%</td><td>Dep: BDI</td></tr><tr><td>Hausmann, 2017，Adults with USA</td><td>osteoar- thritis</td><td>PPI</td><td>Self-help</td><td>Placebo</td><td>6,6 weeks</td><td>3 months</td><td>Ne=19 Nc=19</td><td>69.2 (11.3)</td><td>19</td><td>91% 91%</td><td>SWB: PANAS, SWLS SWB: MHC-</td></tr><tr><td>Hendriks,2018a, Suriname</td><td>Healthy adults</td><td>PPI</td><td>Group</td><td>Waitlist</td><td>7,7 weeks</td><td>1</td><td>Ne=80 Nc=78</td><td>36.3 (9.6)</td><td>60</td><td>91% 91%</td><td>SF-ewb sub- scale; PWB: MHC SF- pwb subscale, Dep,Anx, Stress:</td></tr><tr><td>Huffman, 2011, USA</td><td>Patients with PPI acute car- diovascu- lar disease</td><td></td><td>Group</td><td>Relaxation</td><td>8,8 weeks</td><td></td><td>Ne=9 Nc1=7 Nc2=7</td><td></td><td></td><td>90% 70% 70%</td><td>DASS-21 SWB: SHS Dep: CES-D Anx: HADS-A</td></tr><tr><td>Hwang,2016, China</td><td>Student with PPI depressive symptoms</td><td></td><td>Group</td><td>MM</td><td>12,6 weeks</td><td></td><td>Ne=8 Nc=8</td><td>22.7 (2.3)</td><td>67</td><td>73% 73% 80%</td><td>SWB: SPANE PWB: FS</td></tr></table></body></html>

<html><body><table><tr><td>country</td><td>First author,year,Condition ofInterventionDelivery participants</td><td>type</td><td></td><td>Control group</td><td>Sessions, duration&#x27;</td><td>Follow up</td><td>N post</td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>Ivtzan, 2016,UK</td><td>Healthy adults</td><td>PPI+MM</td><td>Self-help: online</td><td>Waitlist</td><td>8,8 weeks</td><td>1 months</td><td>Ne=53 Nc=11531.5 (13,5)</td><td>40.7 (11.3)</td><td>78 57</td><td>24% 53%</td><td>SWB: PHI; PWB: GSE, PWBS, MLQP, COS, APM Dep: BDI;</td></tr><tr><td>Ivtzan,2018, UKHealthy study 1</td><td>adults</td><td></td><td>Self-help</td><td>Waitlist</td><td>8,8 weeks</td><td></td><td>Ne=22 Nc=21</td><td>39.8 (15.2)78</td><td></td><td>39% 38%</td><td>Stress: PSS SWB: PANAS- pa PWB: MLQ-P, SCs</td></tr><tr><td>Ivtzan, 2018, HKHealthy study 2</td><td>adults</td><td>PPI+MM</td><td>Self-help</td><td>Waitlist</td><td>8,8 weeks</td><td></td><td>Ne=19 Nc=17</td><td>24.3 (8.5)</td><td>39</td><td>35% 31%</td><td>SWB: PANAS- pa PWB: MLQ-P, SCS</td></tr><tr><td>Joutsenniemi, 2014, Finland</td><td>Healthy adults</td><td>PPI</td><td>Self-help: e-mail based</td><td>Placebo</td><td>28， 13 weeks</td><td></td><td>Ne=417 42.0 Nc=433</td><td></td><td>83</td><td>40% 37% 42%</td><td>PWB: HFS Dep: BDI</td></tr><tr><td>Kahler, 2015, USA</td><td>Healthy adults, smoker</td><td>PPI</td><td>Group</td><td>TAU</td><td>6,8 weeks</td><td>26 weeks</td><td>Ne=35 Nc=31</td><td>46.0 (13.4)</td><td>50</td><td>94% 87%</td><td>SWB: CES D-pa Dep: CES-D</td></tr><tr><td>Khayatan, 2014, Iran</td><td>Women with PPI multiple sclerosis</td><td></td><td>Group</td><td>NI</td><td>6.6 weeks</td><td></td><td>Ne=15 Nc=15</td><td>31.1 (6.4)</td><td>100</td><td>100% 100%</td><td>Dep: BDI</td></tr><tr><td>Koydemir, 2016, Turkey</td><td>University students</td><td>PPI</td><td>Self-help: online</td><td>Waitlist</td><td>5,8 weeks</td><td></td><td>Ne=44 Nc =36</td><td>18.7 (1.0)</td><td>48</td><td></td><td>SWB: SHS PWB:WHO- 00</td></tr></table></body></html>

<html><body><table><tr><td>First author, year, country</td><td>Condition of participants</td><td>Intervention type</td><td>Delivery</td><td>Control group</td><td>Sessions, duration</td><td>Follow up</td><td>N post</td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>Lu,2013, China</td><td>Individuals with low trait posi-</td><td>PPI</td><td>Group</td><td>NI</td><td>8,8 weeks</td><td></td><td>Ne=16 Nc=18</td><td>20.0 (4.3)</td><td></td><td>100% 100%</td><td>SWB: PANAS</td></tr><tr><td>Luthans, 2008, USA</td><td>tive affect Healthy adults</td><td>PPI+CBT</td><td>Self-help</td><td>Placebo</td><td>2,2 weeks</td><td></td><td>Ne=187 Nc=177</td><td>32.2</td><td></td><td></td><td>PWB: PCQ</td></tr><tr><td>Luthans, 2010, USA</td><td>Healthy adults</td><td>PPI+CBT</td><td>Group</td><td>CBT</td><td>1, 1 day</td><td></td><td>Ne=153 Nc=89</td><td>21.1</td><td>42</td><td>■</td><td>PWB: PCQ</td></tr><tr><td>Mohammadi, 2018, Iran</td><td>Patients with heart disease</td><td>PPI</td><td>Group</td><td>Placebo</td><td>8,8 weeks</td><td></td><td>Nc=31 Ne=30</td><td>52.5 (5.4)</td><td>23</td><td>97% 93%</td><td>SWB: OHI Dep: HADS- D, Anx: HADS-A</td></tr><tr><td>Moskowitz,2017，Adults with USA</td><td>HIV</td><td>PPI</td><td>Individual</td><td>Placebo</td><td>6,5 months</td><td>5 months</td><td>Ne=74 Nc=76</td><td>36.0 (9.9)</td><td>7.0</td><td>73% 80%</td><td>SWB: DES Dep: CES-D</td></tr><tr><td>Muller, 2016, USA</td><td>Patients, various (muscular) diseases</td><td>PPI</td><td>Self-help</td><td>Placebo</td><td>4, 4-8 weeks</td><td></td><td>2.5 months Ne=39 Nc=38</td><td>59.4 (11.8)</td><td>70</td><td>77% 85%</td><td>SWB: PANAS Dep: HADS-D</td></tr><tr><td>Myers, 2017, USA</td><td>Healthy adults</td><td>PPI</td><td>Self-help: online</td><td>TAU</td><td>7,1 months</td><td>1 months</td><td>Ne=90 Nc=128</td><td>41.9 (11.8)</td><td>77</td><td>69% 67%</td><td>PWB:ICOPPE Scale</td></tr><tr><td>Neumeier, 2017, Germany</td><td>Healthy adults</td><td>PPI</td><td>Group</td><td>Waitlist</td><td>7</td><td></td><td>Ne=90 Nc =128</td><td>41..2 (12.3)</td><td>67</td><td>63% 89%</td><td>SWB: SHS, SAS</td></tr><tr><td>Nikrahan, 2016, Iran</td><td>Cardiac patients</td><td>PPI</td><td>Group</td><td>Waitlist</td><td>6,6 weeks</td><td>8 weeks</td><td>Ne=32 Nc=12</td><td>56.6 (8.7)</td><td>43</td><td>78% 87%</td><td>SWB: OHI Dep: BDI</td></tr><tr><td>Page,2013, Australia</td><td>Healthy adults</td><td>PPI</td><td>Group</td><td>NI</td><td>6,6 weeks</td><td>6 months</td><td>Ne=18 Nc=13</td><td>39.7 (10.0)</td><td>73</td><td>58% 43%</td><td>SWB: SWLS, PANAS PWB:SPWB</td></tr></table></body></html>

<html><body><table><tr><td>First author, year, country</td><td>participants</td><td>Condition ofIntervention type</td><td>Delivery</td><td>Control group</td><td>Sessions, duration</td><td>Follow up</td><td>N post</td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>Peters, 2017, the Netherlands</td><td>Patients with PPI chronic pain</td><td></td><td>Self-help: online</td><td>CBT</td><td>8,8 weeks</td><td>6 months</td><td>Ne=85 Nc=80</td><td>48.5 (12.0)</td><td>85</td><td>73% 69% 80%</td><td>SWB: BMIS + other Dep: HADS-D Anx: HADS-A</td></tr><tr><td>Proyer, 2016, Switzerland</td><td>Healthy adults</td><td>PPI</td><td>Group</td><td>Waitlist</td><td>5,12</td><td>1 months</td><td>Ne=50 Nc =50</td><td>45.7 (12.8)</td><td>69</td><td>33%</td><td>SWB: AHI PWB: OTH</td></tr><tr><td>Roepke, 2015, USA</td><td>Adults with depression symptoms</td><td>PPI+CBT</td><td>Self-help: phone based</td><td>Waitlist</td><td>1 months</td><td>6 weeks</td><td>Ne=93 Nc=93</td><td>40.1 (12.4)</td><td>70</td><td>22% 19% 42%</td><td>SWB: SWLS Dep: CES-D Anx: GADS</td></tr><tr><td>Rogerson, 2016, USA</td><td>Healthy adults</td><td>PPI+CBT</td><td>Group</td><td>Waitlist</td><td>5,5 weeks</td><td></td><td>Ne=14 Nc=14</td><td></td><td></td><td>93% 100%</td><td>PWB: RAW</td></tr><tr><td>Sanjuan, 2016, Spain Schotanus-Dijk-</td><td>Cardiac patients Adults with</td><td>PPI</td><td>Group</td><td>TAU</td><td>24,8 weeks</td><td></td><td>Ne=57 Nc=51</td><td>54.4 (9.1)</td><td>17</td><td>88% 84%</td><td>SWB: PANAS Dep: SCL-90-R SWB -MHC-</td></tr><tr><td>stra, 2017, the Netherlands</td><td>low or moderate well-being</td><td>PPI</td><td>Self-help: e-mail sup- port</td><td>Waitlist</td><td>8,9 weeks</td><td>6 months</td><td>Ne=137 Nc=138</td><td>47.8 (10.9)</td><td>86</td><td>89% 95%</td><td>SF- ewb sub- scale; PWB: MHC-SF, pwb subscale, Dep: HADS- D</td></tr><tr><td>Schueller, 2012, USA</td><td>Self-help- seeking partici- pants</td><td>PPI</td><td>Self-help: online</td><td>NI</td><td>6,6 weeks</td><td></td><td>Ne=151 Nc=204</td><td></td><td></td><td>47% 57%</td><td>Dep: CES-D</td></tr></table></body></html>

e 1 (continue   
  

<html><body><table><tr><td>irst author,year,ConditionofInterventionDelivery ountry</td><td>participants</td><td>type</td><td></td><td>Control group</td><td>Sessions, duration</td><td>Follow upN post</td><td></td><td>Mean age/ SD</td><td>% femalea Reten-</td><td>tion PPI controls</td><td>Outcome measures</td></tr><tr><td>eligman,2006, USA, study 1</td><td>Students, mild depressive symptoms</td><td>PPI</td><td>Group</td><td>NI</td><td>6,6 weeks</td><td>3 months</td><td>Ne=19 Nc=21</td><td>42</td><td></td><td></td><td>SWB: SWLS Dep: BDI</td></tr><tr><td>eligman,2006, USA, study 2</td><td>Adults with major depressive disorder</td><td>PPI</td><td>Individual</td><td>TAU</td><td>14， 12 weeks</td><td></td><td>Ne=11 Nc1=9</td><td></td><td>69</td><td>87% 60% 71%</td><td>SWB: SWLS PWB:PPTI Dep: HRSD</td></tr><tr><td>Jliaszek,2016, Canada</td><td>University students</td><td>PPI+DBT</td><td>Group</td><td>DBT</td><td>12， 12 weeks</td><td></td><td>Ne=15 Nc=22</td><td>22.2 (5.0)</td><td>78</td><td>56% 85%</td><td>PWB: PPTI/; Dep/Anx: SCL-90-R D/A; Stress: DTS</td></tr></table></body></html>

# 3.4 Quality Assessment

The quality score of the studies ranged from one to six, the mean score was 3.22 $\mathrm { \Delta S D } { } = 1 . 7 7 { }$ ). Thirteen studies were rated as high-quality studies $( 2 6 \% )$ , with four studies $( 8 \% )$ meeting all the six quality criteria. Twenty-one studies $(42 \% )$ were of moderate quality and 16 studies $( 3 2 \% )$ were rated as low-quality studies. Twenty-eight studies $( 5 6 \% )$ reported adequately how randomization took place. In 24 studies $(4 8 \% )$ , the allocation of the participants was concealed. In 29 studies $( 5 8 \% )$ , the blinding of outcome assessment was described. An adequate description of drop-outs was provided in 37 studies $( 7 4 \% )$ . Twenty-two studies $(4 4 \% )$ had a population size larger than 50 per allocated arm or the population size was based on a power calculation. Twenty-one studies $(42 \% )$ analyzed outcomes on the basis of an intention-to-treat analysis or had zero drop-outs. The outcome of the quality assessment is shown in Table 2.

# 3.5 Post‑treatment Efects of MPPI’s

We calculated post-treatment for the following outcomes: subjective well-being, psychological well-being, depression, anxiety, and stress. This was done for all studies, studies excluding outliers, and we also calculated the efects sizes for all outcomes excluding low quality studies. Follow-up efects including outliers were calculated for all outcomes except for stress. Follow-up efects excluding outliers was only calculated for subjective well-being and depression, due to the limited number of studies reporting follow-up efects on these outcomes. The main results are presented in Table 3.

# 3.5.1 Efects on Subjective Well‑Being

For subjective well-being, a signifcant small to moderate efect was observed $\scriptstyle ( g = 0 . 3 4$ , $9 5 \%$ CI 0.18–0.50, $p { < } 0 . 0 0 1 $ ) at post-treatment based on 39 comparisons. The efect sizes of the studies ranged from $- 0 . 8 6$ to 2.26. Heterogeneity analysis revealed a signifcant and high level of heterogeneity $\mathrm { T } ^ { 2 } { = } 8 0 . 2 4$ , Q: 192.27, $p { < } 0 . 0 0 1 $ ). Removing eight outliers reduced both the efect size $\scriptstyle ( g = 0 . 2 4$ , $9 5 \%$ CI 0.15–0.33, $p { < } 0 . 0 0 1$ ) and the heterogeneity, which was small $( \mathrm { I } ^ { 2 } = 2 5 . 2 9 $ , $\mathrm { Q = } 4 0 . 1 6$ , $p { < } 0 . 0 0 1$ ). When low-quality studies were excluded, the efect size remained small ( $g = 0 . 2 6$ , $9 5 \%$ CI 0.07–0.44, $p { < } 0 . 0 1 $ ) with a high level of heterogeneity $( \mathrm { I } ^ { 2 } { = } 8 2 . 1 0$ , $\mathrm { Q } = 1 3 9 . 6 3$ , $p { < } 0 . 0 0 1$ ). The forest plot in Fig. 2 displays the post-treatment efects, including outliers.

# 3.5.2 Efects on Psychological Well‑Being

For psychological well-being, a signifcant moderate efect was observed $\scriptstyle { \mathcal { g } } = 0 . 3 9$ , $9 5 \%$ CI 0.23–0.55, $p { < } 0 . 0 0 1 $ ) at post-treatment based on 24 comparisons. Efect sizes ranged from to $- 0 . 4 4$ to 1.58. Heterogeneity was signifcant and high $( \mathrm { I } ^ { 2 } = 7 7 . 5 5$ , $\mathrm { Q } = 1 0 2 . 4 4$ , $p { < } 0 . 0 0 1 $ ) Removing six outliers reduced the efect size $\scriptstyle { g = 0 . 3 5 }$ , $9 5 \%$ CI 0.22–0.48, $p { < } 0 . 0 0 1 $ ). After omitting outliers, heterogeneity was reduced to moderate $( \mathrm { I } ^ { 2 } { = } 4 2 . 5 9$ , $Q = 2 9 . 6 1$ , $p { < } 0 . 0 5 )$ .

Table 2 Quality assessment of RCTs   

<html><body><table><tr><td>Studies</td><td>SG</td><td>AC</td><td>BOA</td><td>DW</td><td>PA</td><td>ITT</td><td>Tally</td><td>Quality</td></tr><tr><td>Bolier et al. (2013b)</td><td>1</td><td>1</td><td>0</td><td>1</td><td>1</td><td>1</td><td>5</td><td>High</td></tr><tr><td>Celano et al. (2017)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>1</td><td>5</td><td>High</td></tr><tr><td>Drozd et al. (2014)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>6</td><td>High</td></tr><tr><td>Dyrbye et al. (2016)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>5</td><td>High</td></tr><tr><td>Feicht et al. (2013)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>5</td><td>High</td></tr><tr><td>Hendriks (2018)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>6</td><td>High</td></tr><tr><td>Ivtzan et al. (2016)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>5</td><td>High</td></tr><tr><td>Joutsenniemi et al. (2014)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>6</td><td>High</td></tr><tr><td>Kahler et al. (2015)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>1</td><td>5</td><td>High</td></tr><tr><td>Moskowitz et al. (2017)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>1</td><td>1</td><td>5</td><td>High</td></tr><tr><td>Myers et al. (2018)</td><td>1</td><td>1</td><td>1</td><td>0</td><td>1</td><td>1</td><td>5</td><td>High</td></tr><tr><td>Roepke et al. (2015)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>6</td><td>High</td></tr><tr><td>Schotanus-Dijkstra et al. (2017)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>1</td><td>1</td><td>5</td><td>High</td></tr><tr><td>Carr and Finnegan (2015)</td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>1</td><td>3</td><td>Moderate</td></tr><tr><td>Cohn et al. (2014)</td><td>1</td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>3</td><td>Moderate</td></tr><tr><td>Chaves et al. (2017)</td><td>0</td><td>1</td><td>1</td><td>1</td><td>0</td><td>1</td><td>4</td><td>Moderate</td></tr><tr><td>Cheung et al. (2017)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Cohn et al. (2014)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Cullen et al. (2016)</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Drozd (2014b)</td><td>0</td><td>1</td><td>0</td><td>1</td><td>0</td><td>1</td><td>3</td><td>Moderate</td></tr><tr><td>Hausmann et al. (2017)</td><td>1</td><td>1</td><td>0</td><td>1</td><td>0</td><td>1</td><td>4</td><td>Moderate</td></tr><tr><td>Ivtzan et al. (2018), study 1</td><td>1</td><td>1</td><td>0</td><td>0</td><td>1</td><td>1</td><td>4</td><td>Moderate</td></tr><tr><td>Ivtzan et al. (2018), study 2</td><td>1</td><td>1</td><td>0</td><td>0</td><td>1</td><td>1</td><td>4</td><td>Moderate</td></tr><tr><td>Luthans et al. (2008)</td><td>1</td><td>1</td><td>1</td><td>0</td><td>1</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Mohammadi et al. (2018)</td><td>1</td><td>0</td><td>1</td><td>0</td><td>1</td><td>1</td><td>4</td><td>Moderate</td></tr><tr><td>Muller et al. (2016)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>3</td><td>Moderate</td></tr><tr><td>Nikrahan et al. (2016)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>3</td><td>Moderate</td></tr><tr><td>Page and Vella-Brodrick (2013)</td><td>0</td><td>1</td><td>0</td><td>1</td><td>1</td><td>1</td><td>4</td><td>Moderate</td></tr><tr><td>Peters et al. (2017)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>1</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Proyer et al. (2016)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>1</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Rogerson et al. (2016)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>3</td><td>Moderate</td></tr><tr><td>Sanjuan et al. (2016)</td><td>1</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>3</td><td>Moderate</td></tr><tr><td>Schueller and Parks (2012) Uliaszek et al. (2016)</td><td>0</td><td>1</td><td>1</td><td>1</td><td>1</td><td>0</td><td>4</td><td>Moderate</td></tr><tr><td>Antoine et al. (2018)</td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>1</td><td>3</td><td>Moderate</td></tr><tr><td>Asgharipoor et al. (2012)</td><td>0</td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>2</td><td>Low</td></tr><tr><td>Asl et al. (2014)/Asl et al. (2016)</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>Low</td></tr><tr><td></td><td>0</td><td>0</td><td>0</td><td>1</td><td>0</td><td>0</td><td>1</td><td>Low</td></tr><tr><td>Cantarella et al. (2017)</td><td>0</td><td>0</td><td>0</td><td>1</td><td>0</td><td>1</td><td>2</td><td>Low</td></tr><tr><td>Dowlatabadi et al. (2016)</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>Low</td></tr><tr><td>Gelfin et al. (2018)</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>Low</td></tr><tr><td>Guo et al. (2016)</td><td>0</td><td>0</td><td>0</td><td>1</td><td>0</td><td>0</td><td>1</td><td>Low</td></tr><tr><td>Huffman et al. (2011) Hwang et al. (2016)</td><td>0 1</td><td>1 0</td><td>0 0</td><td>0 1</td><td>0 0</td><td>0 0</td><td>1 2</td><td>Low</td></tr><tr><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td>Low</td></tr><tr><td>Khayatan et al. (2014)</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>Low</td></tr></table></body></html>

Table 2 (continued)   

<html><body><table><tr><td>Studies</td><td>SG</td><td>AC</td><td>BOA</td><td>DW</td><td>PA</td><td>ITT</td><td>Tally</td><td>Quality</td></tr><tr><td>Koydemir and Sun-Selisik (2016)</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>0</td><td>2</td><td>Low</td></tr><tr><td>Lu et al. (2013)</td><td>0</td><td>0</td><td>0</td><td>1</td><td>0</td><td>0</td><td>1</td><td>Low</td></tr><tr><td>Luthans et al. (2010)</td><td>0</td><td>0</td><td>0</td><td>0</td><td>1</td><td>0</td><td>1</td><td>Low</td></tr><tr><td>Neumeier et al. (2017)</td><td>0</td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>2</td><td>Low</td></tr><tr><td>Seligman et al. (2006), study 1</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>Low</td></tr><tr><td>Seligman et al. (2006),study 2</td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>2</td><td>Low</td></tr></table></body></html>

SG sequence generation, $A C$ allocation concealment, BOA blinding of main outcome assessments, DW description of withdrawals/drop-outs, $P A$ power analysis or $\mathrm { N } > 5 0$ , $I T T$ intention-to-treat analysis/0 dropouts

When studies of low quality were excluded, the efect size was reduced $g = 0 . 3 1$ , $9 5 \%$ CI 0.15–0.47, $p { < } 0 . 0 5 $ , with a signifcant moderate to high level of heterogeneity $( \mathrm { I } ^ { 2 } = 7 5 . 7 5$ , $\mathrm { Q } { = } 6 5 . 9 9$ , $p { < } 0 . 0 0 1$ ). The forest plot in Fig. 3 displays the post-treatment efects.

# 3.5.3 Efects on Depression

For depression (25 comparisons), a signifcant small efect was observed $g = 0 . 3 2$ , $9 5 \%$ CI 0.13–0.51, $p { < } 0 . 0 0 1 $ ) at post-treatment. Efect sizes of studies ranged from $- 1 . 5 0$ to 3.05. Heterogeneity was signifcant and high $( \mathrm { I } ^ { 2 } = 8 0 . 5 5$ , $\mathrm { Q } = 1 2 3 . 4 0$ , $p { < } 0 . 0 0 1$ ). Removing one outlier (Guo et al. 2016) reduced the efect size $\scriptstyle ( g = 0 . 2 1$ , $9 5 \%$ CI 0.07–0.36, $p { = } 0 . 0 0 4 )$ ) and heterogeneity was moderate $\mathrm { T } ^ { 2 } { = } 6 5 . 1 6$ , $\mathrm { Q } { = } 6 6 . 0 1$ , $\scriptstyle p = 0 . 0 0 0$ ). When studies with a low quality were excluded, the efect size was no longer signifcant. The post-treatment efects are displayed in a forest plot in Fig. 4.

# 3.5.4 Efects on Anxiety

For anxiety, a signifcant small to moderate efect was observed $g = 0 . 3 5$ , $9 5 \%$ CI 0.23–0.48, $p { < } 0 . 0 0 1 $ ) at post-treatment based on 11 comparisons. Efect sizes of studies ranged from $- 0 . 7 0$ to 1.16, and there were no outliers. The level of heterogeneity was not signifcant. When two low quality studies were excluded, the efect size was slightly reduced $\scriptstyle { g = 0 . 3 3 }$ , $9 5 \%$ CI 0.19–0.46, $p { < } 0 . 0 0 1$ ) and the heterogeneity remained insignifcant. The forest plot in Fig. 5 displays the post-treatment efects.

# 3.5.5 Efects on Stress

For stress, a signifcant small to moderate efect was observed $\scriptstyle { g = 0 . 3 5 }$ , $9 5 \%$ CI 0.03–0.66, $p { < } 0 . 0 5 )$ at post-treatment, based on 8 comparisons. Efect sizes of studies ranged from $- 2 . 2 5$ to 1.89. Heterogeneity was low $( \mathrm { I } ^ { 2 } = 2 0 . 1 9 $ , $\mathrm { Q } { = } 6 5 . 3 2$ , $p { < } 0 . 0 1 $ ). When one outlier was removed, the efect size increased $g = 0 . 4 9$ , $9 5 \%$ CI 0.28–0.69, $p { < } 0 . 0 0 1$ ). Heterogeneity was no longer signifcant. When one low quality study was excluded, the efect size remained moderate $g = 0 . 4 8$ , $9 5 \%$ CI 0.28–0.69, $p { < } 0 . 0 0 1 $ ) and the heterogeneity remained insignifcant. The forest plot in Fig. 6 displays the post-treatment efects.

Table 3 Between—group efects   

<html><body><table><tr><td rowspan="2">Outcome measures</td><td rowspan="2"></td><td rowspan="2"># studies Hedge&#x27;sg 95% CI</td><td rowspan="2"></td><td rowspan="2">Z</td><td colspan="2">Heterogeneity</td><td rowspan="2">Fail-safe N</td></tr><tr><td>Q value</td><td></td></tr><tr><td colspan="9">All studies post-treatment</td></tr><tr><td>Subjective well-being</td><td>39</td><td>0.34</td><td>(0.18-0.50)</td><td>4.15***</td><td>191.28***</td><td>80.24755</td><td></td></tr><tr><td>Psychological well- being</td><td>24</td><td>0.39</td><td>(0.23-0.55)</td><td>4.88***</td><td>102.44***</td><td>77.55</td><td>459</td></tr><tr><td>Depression</td><td>31</td><td>0.29</td><td>(0.14-0.45)</td><td>3.76***</td><td>131.35***</td><td>77.16346</td><td></td></tr><tr><td>Anxiety</td><td>11</td><td>0.35</td><td>(0.23-0.48)</td><td>5.77***</td><td>12.19ns</td><td>17.94</td><td>92</td></tr><tr><td>Stress</td><td>8</td><td>0.35</td><td>(0.03-0.66)</td><td>2.16*</td><td>20.19**</td><td>65.32</td><td>24</td></tr><tr><td colspan="8">Studies post-treatment, excl. outliers</td></tr><tr><td>Subjective well-being</td><td>31</td><td>0.24</td><td>(0.15-0.33)</td><td>5.23***</td><td>40.16ns</td><td>25.29-</td><td></td></tr><tr><td>Psychological well- being</td><td>18</td><td>0.35</td><td>(0.22-0.48)</td><td>5.31***</td><td>29.61**</td><td>42.59-</td><td></td></tr><tr><td>Depression</td><td>28</td><td>0.21</td><td>(0.07-0.29)</td><td>3.10**</td><td>60.63***</td><td>55.47</td><td></td></tr><tr><td>Stress</td><td>7</td><td>0.49</td><td>(0.28-0.69)</td><td>4.66***</td><td>7.85ns</td><td>23.53</td><td></td></tr><tr><td colspan="8">Studies post-treatment,excl. low quality studies</td></tr><tr><td>Subjective well-being</td><td>26</td><td>0.26</td><td>(0.07-0.44)</td><td>2.76**</td><td>139.63***</td><td>82.10</td><td>1</td></tr><tr><td>Psychological well- being</td><td>17</td><td>0.31</td><td>(0.15-0.47)</td><td>3.78***</td><td>65.99***</td><td>75.75-</td><td></td></tr><tr><td>Depression</td><td>21</td><td>0.14</td><td>(0.03-0.26)</td><td>2.43*</td><td>42.53**</td><td>52.97</td><td>1</td></tr><tr><td>Anxiety</td><td>9</td><td>0.33</td><td>(0.19-0.46)</td><td>4.79***</td><td>10.75ns</td><td>25.57</td><td>1</td></tr><tr><td>Stress</td><td>7</td><td>0.49</td><td>(0.28-0.69)</td><td>4.66***</td><td>7.85ns</td><td>23.53-</td><td></td></tr><tr><td colspan="8">Follow-up effects</td></tr><tr><td>Subjective well-being</td><td>17</td><td>0.27</td><td>(0.07-0.48)</td><td>2.61**</td><td>56.80***</td><td>71.83-</td><td></td></tr><tr><td>Psychological well- being</td><td>5</td><td>0.32</td><td>(0.01-0.63)</td><td>1.99*</td><td>19.91***</td><td>79.91-</td><td></td></tr><tr><td>Depression</td><td>15</td><td>0.45</td><td>(0.15-0.76)</td><td>2.91**</td><td>88.29***</td><td>84.14-</td><td></td></tr><tr><td>Anxiety</td><td>5</td><td>0.09</td><td>(-0.44 to 0.62)</td><td>0.33ns</td><td>36.23***</td><td>88.95</td><td></td></tr><tr><td colspan="8">Follow-up effects excl.outliers</td></tr><tr><td>Subjective well-being</td><td>14</td><td>0.24</td><td>(0.15-0.37)</td><td>2.48*</td><td>33.26***</td><td>60.91-</td><td></td></tr><tr><td>Depression</td><td>14</td><td>0.31</td><td>(0.07-0.54)</td><td>2.57*</td><td>43.88***</td><td>70.38-</td><td></td></tr></table></body></html>

For anxiety there were no outliers. Follow-up efects for stress and follow-up efects exclusive outliers for psychological well-being, anxiety, and stress were not calculated because there were less than 5 studies per category ns non-signifcant   
$^ { * } p < 0 . 0 5$ ; $^ { * * } p < 0 . 0 1$ ; $^ { * * * } p < 0 . 0 0 1$

# 3.5.6 Subgroup Analyses

We did not fnd any signifcant results for subjective well-being and psychological wellbeing. For depression, signifcant higher efect sizes were found for low quality studies compared to studies with a high quality. Studies of low quality $( n = 1 0 )$ ) had a large efect size $g = 0 . 7 5$ , $9 5 \%$ CI 0.47–1.04, $p { < } 0 . 0 0 1 $ ), whereas studies of high quality $( n = 9 )$ had a small efect size $g = 0 . 2 2$ , $9 5 \%$ CI 0.00–0.45, $p { < } 0 . 0 1 $ .

![](images/8e3447355d85e0c3ac7260273604c0bc147cf5e45223131d05ec9cb235671c24.jpg)  
Fig. 2 Post-test efects of MPPIs on subjective well-being (SWB), including outliers

![](images/14b58f70e375050fa3c099c31fe2d1ddf0cabbb9101c0423c938cf9847958b82.jpg)  
Fig. 3 Post-test efects of MPPIs on psychological well-being (PWB), including outliers

![](images/efa350fe76215f24e2ce5a34987ea5031d1c18c185b3d81cd15345ef8f8afc99.jpg)  
Fig. 4 Post-test efects of MPPIs on depression, including outliers

![](images/d1374543a539492f63e5261a4d8ae1ee96accffc63376b9bbb82ddbf9c8e5a77.jpg)

Fig. 5 Post-test efects of MPPIs on anxiety, including outliers

![](images/059483a5f82183546f59093d0cd08ba3aa187963a5ea90eb68db4afd8caffffd.jpg)  
Fig. 6 Post-test efects of MPPIs on stress, including outliers

In addition, the region of origin of the studies also had a signifcant moderating efect on this outcome: studies from non-Western countries $( n = 8 )$ had a large efect size $( g = 0 . 7 2$ , $9 5 \%$ CI 0.41–1.03, $p { < } 0 . 0 0 1$ ), whereas studies from Western countries $\left( n = 2 3 \right)$ ) had a small efect size $g = 0 . 2 7$ , $9 5 \%$ CI 0.01–0.33, $p { < } 0 . 0 5 $ . All outcomes of the subgroup analyses are shown in “Appendix $3 ^ { \circ }$ .

# 3.5.7 Publication Bias

The possibility of publication bias was determined for subjective well-being, psychological well-being, and depression because of the small number of studies included for anxiety and stress. We found some indications of publication bias, but the results were not conclusive. The funnel plots for subjective well-being, psychological well-being, and depression were somewhat asymmetrical, with a few more studies showing a positive outcome. However, the fail-safe numbers were higher for subjective well-being (755), psychological well-being (459), and depression (346) than required (205, 130, and 155 respectively). Contrary to the funnel plots, Egger’s regression intercept was signifcant for psychological well-being (2.23, $\mathrm { t } = 2 . 9 6$ , $d f = 2 2$ , $p { < } 0 . 0 1 $ ) and depression (1.50, $\mathrm { t } = 2 . 0 6$ , $d f = 2 9$ , $p { < } 0 . 0 5 )$ , but not signifcant for subjective well-being (0.72, $\mathrm { t } = 0 . 7 9$ , $d f = 3 7$ , $\begin{array} { r } { p { = } 0 . 4 3 , } \end{array}$ ) Finally, when possible missing studies were imputed using the Duval and Tweedie’s trim-and-fll method, the adjusted efect sizes increased for subjective well-being $\scriptstyle ( g = 0 . 4 5$ , $9 5 \%$ CI 0.34–0.67), but decreased for psychological well-being $\scriptstyle { \mathcal { B } } = 0 . 2 4$ , $9 5 \%$ CI 0.23–0.55) and depression $\scriptstyle ( g = 0 . 2 0$ , $9 5 \%$ CI 0.17–0.48). In sum, potential missing publications may have infuenced the results of the meta-analyses.

# 3.5.8 Follow‑Up Efects

Follow-up periods ranged from 1 to 12 months. Analysis showed a signifcant small efect $\scriptstyle { g = 0 . 2 7 }$ , $9 5 \%$ CI 0.07–0.48, $p { < } 0 . 0 1 $ ) for subjective well-being at follow-up measurement (17 comparisons). After removal of three outliers, the efect size decreased $g = 0 . 2 4$ , $9 5 \%$ $\mathrm { C I } 0 . 0 5  – 0 . 4 3$ , $p { < } 0 . 0 5 $ ). The efects for depression at follow-up measurement (15 comparisons) were moderate $g = 0 . 4 5$ , $9 5 \%$ CI 0.15–0.76, $p { < } 0 . 0 1 $ , but this efect-size dropped to small after removing one outlier $g = 0 . 3 1$ , $9 5 \%$ CI 0.07–0.54, $p { < } 0 . 0 1$ ). The followup efect size for psychological well-being was also small $\scriptstyle ( g = 0 . 3 2$ , $9 5 \%$ CI 0.00–0.70, $p { < } 0 . 0 5 )$ . We did not calculate follow-up efect sizes for psychological well-being, anxiety, and stress due to the small number of studies reporting follow-up efects (5, 5, and 3 respectively).

# 4 Discussion

# 4.1 Main Findings

The aim of this study was to examine the efcacy of multi-component positive psychology interventions (MPPIs) across randomized controlled trials. Following a systematic literature search, we included 51 articles describing 50 studies on the efects of MPPIs in our meta-analysis. We conclude that over the past 6 years, there has been a sharp increase in the number of RCTs involving MPPIs. In comparison, a meta-analysis of PPIs by Bolier et  al. (2013a, b) that featured studies from 1998 to November 2012, included 34 single component PPIs and merely fve MPPIs. Analyses of all studies suggest that MPPIs have small to moderate efect sizes for subjective well-being $\scriptstyle ( g = 0 . 3 4 )$ , psychological wellbeing $\scriptstyle ( g = 0 . 3 9 )$ , anxiety $( g = 0 . 3 5 )$ , and stress $( g = 0 . 3 5 )$ , and a small efect size for depression $g = 0 . 2 9 ,$ . After removing outliers, the efect sizes decreased for subjective well-being $\scriptstyle ( g = 0 . 2 4 )$ , psychological well-being $\scriptstyle ( g = 0 . 3 5 )$ , and depression $( g = 0 . 2 1 )$ , but increased for stress $\scriptstyle { \overset { \prime } { g } = 0 . 4 9 } )$ . There were no outliers for anxiety. Removing low quality studies led to similar conclusions compared to the analyses without the low quality studies, in part because the outliers were often of low quality. Follow-up results showed small efects for subjective well-being $\scriptstyle ( g = 0 . 2 7 )$ , and psychological well-being $( g = 0 . 3 2 )$ . The efect size for depression increased to moderate $\scriptstyle ( g = 0 . 4 5 )$ ), while the efect size for anxiety sharply dropped $\scriptstyle ( g = 0 . 0 9 )$ ). Follow-up efects for stress were not calculated due to the limited amount of studies that included follow-up assessments.

Our fndings on subjective well-being, psychological well-being, and depression are in line with two previous meta-analyses of RCT’s on the efect of PPIs. Bolier et al. (2013a, b) reported small efects on these outcomes, and a recent meta-analysis by Chakhssi et al. (2018) in clinical samples with psychiatric or somatic disorders, also reported small efects on well-being and depression. According to the Synergistic Change Model (Rusk et  al. 2018) lasting positive change as a result of a PPI, is most likely to occur when interventions are targeted at multiple domains of positive functioning. The model suggests that targeting multiple domains decreases the risk of relapse and increases the likelihood of spillover efects and synergy between the various activities. We expected to fnd higher efect sizes for all outcomes well-being and depression, since MPPIs target multi-domains of positive functioning. Although larger efect sizes on subjective well-being, psychological well-being, and depression were not found, compared to the studies of Bolier et al. (2013a, b) and Chakhssi et al. (2018), the efect sizes were still of small to moderate magnitude. Our meta-analysis is the frst that found promising results for PPIs on anxiety, and stress in particular. Still, the total number of studies that reported on these outcomes was limited, so caution is warranted when drawing conclusions on the efects of MPPIs on anxiety and stress.

Explorative subgroup analyses revealed mainly no signifcant results, indicating that we could not identify study or intervention characteristics that led to more or less efectivity of MPPIs. We only found that two moderators may have infuenced the outcomes on depression. Low quality studies had a signifcant higher efect size than moderate or high quality studies. Our fnding that studies of lower quality have a higher efect size on depression is in line with the fndings of the meta-analysis of Bolier et al. (2013a, b). However, they reported a higher efect size for low quality studies compared to studies from moderate quality, rather than studies of high quality. In addition, Bolier and colleagues also reported signifcant higher efects for low quality studies compared to moderate quality studies on subjective well-being and psychological well-being, whereas we did not. The meta-analysis by Chakhssi et al. (2018) reported a signifcant moderating efect of study quality only for well-being, and not for depression. Diferences can be explained by the fact that all metaanalyses used diferent criteria to measure quality. Bolier and colleagues assessed the study quality on fve criteria, of which two criteria difered from the criteria that were used in our study, whereas Chakhssi and colleagues used six criteria, of which fve were the same as the criteria we used.

In addition, we found that the region of origin of the studies had a signifcant moderating efect on depression: studies from non-Western countries reported higher efect sizes than studies from Western countries. Diferences in efect sizes between Western and non-Western countries are possibly confounded by study quality, because six of the ten low-quality studies on depression were from non-Western countries. The fndings in relation to the lower quality of studies from non-Western countries and possible large efect sizes are in line with a meta-analysis that we recently conducted on the efcacy of PPIs from non-Western countries (Hendriks et  al. 2018b). This study, that included $2 8 ~ \mathrm { R C T s }$ , showed that PPIs from non-Western countries have moderate efect sizes on well-being, and large efects on depression and anxiety. Quality analysis, using the same six criteria that were used in this current study, revealed a mean quality score of 1.79 $\mathrm { S D } { = } 1 . 7$ ), indicating a low quality. The quality analysis of the current meta-analysis showed that nonWestern studies had a mean rating score of 1.89 $( \mathrm { S D } = 1 . 8 )$ ), compared to a mean rating score of 3.62 $\mathrm { S D } { = } 1 . 5$ ) for Western countries. This diference was signifcant $( p < 0 . 0 5 )$ . Lower quality may contribute to higher efect sizes. An important aspect is sample size. Prior studies have shown that trials with small sample sizes tend to overestimate efect sizes (Slavin and Smith 2009; Zhang et al. 2013). Our analyses showed that the intervention groups in the studies from non-Western countries had much smaller sample sizes (mean $= 2 7$ ), than the groups in the studies from Western countries (mean $= 7 1$ ).

# 4.2 Strengths and Limitations

One of the strengths of this meta-analysis is its methodological rigor. It was conducted according to The Preferred Reporting Items for Systematic Reviews and Meta-Analyses (PRISMA) guidelines for systematic reviews and meta-analyses (Moher et al. 2009, 2010) and the recommendations of the Cochrane Back Review group (Higgins et  al. 2011). Another strength is the diferentiation of the intervention by region. In general, PPI studies from non-Western countries tend to report larger efect-size than studies from Western countries. Our moderator analysis showed the moderating efect is signifcant for depression. This fnding may contribute to a better understanding of the moderating efect of the region on the efcacy of PPIs, or at least to a broader examination on the possible reasons why there are diferences. We recommend that other researchers further examine the relationship between the ethnic/cultural background of the participants and the outcomes of interventions.

We believe there are several limitations related to the fndings of this study. First, there is a relatively small number of studies on anxiety $( n = 1 1 )$ ) and stress $( n = 8 )$ . In order to draw frmer conclusions on the efects of MPPIs on these outcomes, more RCTs are needed. Second, there is also a limited number of studies for all subgroups. For example, while for psychological well-being there were 18 studies conducted among non-clinical populations, we only found six studies among clinical populations that measured the efects of the MPPIs. With such a small sample of studies, defnite conclusions on the efects of MPPI on psychological well-being among the clinical population cannot be drawn. With a limited number of studies and, on average, a high level of heterogeneity, the impact of excluding a single study could also have a high impact. This was illustrated in our fndings for stress: based on eight studies we found an efect size of $g = 0 . 3 5$ (a small to moderate efect). However, after removing one outlier (of low quality) the efect size for stress increased to $g = 0 . 4 9$ (moderate efect). The third limitation applies to the quality of the studies, or better said: the lack thereof. Only $2 6 \%$ of the studies could be classifed as high-quality studies $( n = 1 3 )$ ), $4 2 \%$ of the studies $( n = 2 1$ ) were classifed as moderate, and $3 2 \%$ of the studies were classifed as low-quality studies $( n = 1 6 )$ ). The main reasons for the lack of quality are the omission of randomization procedures $5 2 \%$ of the studies), the failure to state whether or not allocation of the participants was concealed $( 5 2 \% )$ , and the failure to state whether or not the outcome assessment was blinded $(42 \% )$ . Furthermore, 29 studies $( 5 8 \% )$ conducted completers-only analyses, as opposed to intention-to-treat analyses, thereby increasing the risk of selection bias (Yelland et  al. 2015). Another aspect is that the majority of the studies is weakly powered: 28 of the 50 studies $( 5 6 \% )$ had a population less than 50 participants per condition. Twenty-two studies $(44 \% )$ even had less than 30 participants in the intervention group. Studies with low power have a weak predictive value, have a low probability of fnding an efect or exaggerate the magnitude of the efect when an efect is discovered (Button et al. 2013; Slavin and Smith 2009).

# 5 Conclusion and Implications

Despite the limitations, we conclude that MPPIs have a small efect on subjective wellbeing and depression, and a small to moderate efect on psychological well-being, and possibly anxiety and stress. However, the limitations also warrant some implications for future research. Firstly, there is a need for a more rigorous methodological approach in studies in the feld of positive psychology, which should lead to higher quality studies. This recommendation is a reoccurring one, which have been stated in some previous PPI metaanalyses as well (Bolier et al. (2013a, b; Weiss et al. 2016). Considering the explicit call for more rigorous research methods to study well-being which is often heard in positive psychology (Diener 2009; Froh 2004; Linley and Joseph 2004; Linley et al. 2006), we recommend that future studies should at least be based on a power-analysis to avoid the risk that clinical trials fail to detect meaningful diferences (Adams-Huet and Ahn 2009), or include a minimum of 50 participants per condition. We also highly recommend that future studies pay more attention to methodological reporting and follow protocols guidelines such as the CONSORT (Moher et al. 2010) or the Standard Protocol Items: Recommendations for Interventional Trials (SPIRIT) guidelines (Chan et al. 2013). In light of the growing number of RCTs from non-Western countries, this recommendation particular applies to studies from such countries, since nine of the eleven non-Western studies we included had a low study quality rating. Secondly, due to the high heterogeneity of the studies it was not possible to determine the optimal conditions under which studies could maximize their efcacy, for example the most efective intervention period or number of sessions. In conclusion, our fndings show for the frst time the overall efcacy of MPPIs and the subgroup analyses contribute to a better understanding of the efectiveness of MPPIs. Future studies among of higher quality and more diverse populations could enrich the feld of positive psychology and mental health and contribute to more insight into the optimal conditions to design the most efective positive psychology interventions.

Authors’ Contributions The meta-analyses and data-analyses were conducted by TH, who also wrote the manuscript. The literature search was conducted by TH and MS, the risk of bias analysis was conducted by TH and AH. JdJ was an advisor in the project. EB was the editor of the article. All authors contributed to the writing of the manuscript and approved the fnal manuscript.

# Compliance with Ethical standards

Confict of interest The authors declare that they have no confict of interest.

# Appendix 1

See Table 4.

Table 4 Strings of the search strategy   
PUBMED: ((well-being[Title/Abstract] OR happiness[Title/Abstract] OR happy[Title/Abstract] OR fourishing[Title/Abstract] OR “life satisfaction”[Title/Abstract] OR “satisfaction with life”[Title/ Abstract] OR optimism[Title/Abstract] OR gratitude[Title/Abstract] OR strengths[Title/Abstract] OR forgiveness[Title/Abstract] OR compassion[Title/Abstract] OR “positive psych\*”[Title/Abstract])) AND “random”\*[Title/Abstract]   
PSYCINFO: well-being or happiness or happy or fourishing or “life satisfaction” or “satisfaction with life” or optimism or gratitude or strengths or forgiveness or compassion or “positive psych\*”).ti. and (“well-being” or happiness or happy or fourishing or “life satisfaction” or “satisfaction with life” or optimism or gratitude or strengths or forgiveness or compassion or “positive psych\*”). ab. and random\*.af   
SCOPUS: #1 well-being or happiness or happy or fourishing or “life satisfaction” or “satisfaction with life” or optimism or gratitude or strengths or forgiveness or compassion or “positive psych\* #2 AND ABS(well-being or happiness or happy or fourishing or “life satisfaction” or “satisfaction with life” or optimism or gratitude or strengths or forgiveness or compassion or “positive psych\*”)AND TITLE-ABS-KEY(random\*)) AND DOCTYPE(ar) AND PUBYEAR >1997 AND (LIMIT-TO (SUBJAREA,”MEDI”) OR LIMIT-TO (SUBJAREA,”HEAL”) OR LIMIT-TO (SUBJAREA,”PSYC”) OR LIMIT-TO (SUBJAREA,”SOCI”) OR LIMIT-TO (SUBJAREA,”NURS”) OR LIMIT-TO (SUBJAREA,”BUSI”) OR LIMIT-TO (SUBJAREA,”MULT”)) AND (LIMIT-TO (LANGUAGE,”English”)) AND (LIMIT-TO (AFFILCOUNTRY,”United States”)) AND (LIMITTO (EXACTKEYWORD,”Human”) OR LIMIT-TO (EXACTKEYWORD,”Article”) OR LIMIT-TO (EXACTKEYWORD,”Humans”) OR LIMIT-TO (EXACTKEYWORD,”Controlled Study”) OR LIMITTO (EXACTKEYWORD,”Male”) OR LIMIT-TO (EXACTKEYWORD,”Female”) OR LIMIT-TO (EXACTKEYWORD,”Adult”) OR LIMIT-TO (EXACTKEYWORD,”Randomized Controlled Trial”) OR LIMIT-TO (EXACTKEYWORD,”Controlled Clinical Trial”) OR LIMIT-TO (EXACTKEYWORD,”Middle Aged”) OR LIMIT-TO (EXACTKEYWORD,”Aged”) OR LIMIT-TO (EXACTKEYWORD,”Clinical Trial”) OR LIMIT-TO (EXACTKEYWORD,”Physiology”) OR LIMIT-TO (EXACTKEYWORD,”Priority Journal”) OR LIMIT-TO (EXACTKEYWORD,”Major Clinical Study”) OR LIMIT-TO (EXACTKEYWORD,”Young Adult”) OR LIMIT-TO (EXACTKEYWORD,”Treatment Outcome”) OR LIMIT-TO (EXACTKEYWORD,”Methodology”) OR LIMIT-TO (EXACTKEYWORD,”Quality Of Life”) OR LIMIT-TO (EXACTKEYWORD,”Clinical Article”) OR LIMIT-TO (EXACTKEYWORD,”Procedures”) OR LIMIT-TO (EXACTKEYWORD,”Questionnaire”) OR LIMIT-TO (EXACTKEYWORD,”Human Experiment”) OR LIMIT-TO (EXACTKEYWORD,”Normal Human”) OR LIMIT-TO (EXACTKEYWORD,”Wellbeing”) OR LIMIT-TO (EXACTKEYWORD,”Double Blind Procedure”) OR LIMIT-TO (EXACTKEYWORD,”Randomization”) OR LIMIT-TO (EXACTKEYWORD,”Depression”) OR LIMIT-TO (EXACTKEYWORD,”Outcome Assessment”) OR LIMIT-TO (EXACTKEYWORD,”Random Allocation”) OR LIMIT-TO (EXACTKEYWORD,”Follow Up”) OR LIMIT-TO (EXACTKEYWORD,”Questionnaires”) OR LIMIT-TO (EXACTKEYWORD,”Exercise Therapy”) OR LIMIT-TO (EXACTKEYWORD,”Time”) OR LIMIT-TO (EXACTKEYWORD,”Animals”) OR LIMITTO (EXACTKEYWORD,”Double-Blind Method”) OR LIMIT-TO (EXACTKEYWORD,”Well-being”) OR LIMIT-TO (EXACTKEYWORD,”Psychology”) OR LIMIT-TO (EXACTKEYWORD,”Psychological Aspect”) OR LIMIT-TO (EXACTKEYWORD,”Stress, Mechanical”) OR LIMIT-TO (EXACTKEYWORD,”Training”) OR LIMIT-TO (EXACTKEYWORD,”Physical Activity”) OR LIMIT-TO (EXACTKEYWORD,”Strength”) OR LIMIT-TO (EXACTKEYWORD,”Mental Health”) OR LIMIT-TO (EXACTKEYWORD,”Placebo”) OR LIMIT-TO (EXACTKEYWORD,”Health Status”) OR LIMIT-TO (EXACTKEYWORD,”Happiness”) OR LIMIT-TO (EXACTKEYWORD,”Personal Satisfaction”) OR LIMIT-TO (EXACTKEYWORD,”Self Concept”) OR LIMIT-TO (EXACTKEYWORD,”Life Satisfaction”) OR LIMIT-TO (EXACTKEYWORD,”Follow-Up Studies”) OR LIMIT-TO (EXACTKEYWORD,”Anxiety”) OR LIMIT-TO (EXACTKEYWORD,”Satisfaction”) OR LIMIT-TO (EXACTKEYWORD,”Psychological Well Being”) OR LIMIT-TO (EXACTKEYWORD,”Self Report”) OR LIMIT-TO (EXACTKE YWORD,”Instrumentation”) OR LIMIT-TO (EXACTKEYWORD,”Emotion”) OR LIMIT-TO (EXACTKEYWORD,”Adaptation, Psychological”) OR LIMIT-TO (EXACTKEYWORD,”United States”) OR LIMIT-TO (EXACTKEYWORD,”Fatigue”) OR LIMIT-TO (EXACTKEYWORD,”Social Support”) OR LIMIT-TO (EXACTKEYWORD,”Afect”) OR LIMIT-TO (EXACTKEYWORD,”Pilot Study”)

# Appendix 2

See Table 5.

Subjective well-being AHI: Authentic Happiness Indexa ; BMIS: Brief Mood Introspection Scale (BMIS); CES-D pa: Center for Epidemiological Studies Depression Scale, positive afect subscale; MHC-SF-ewb subscale: Mental Health Continuum-Short Form—emotional well-being subscale; OHI: Oxford Happiness Index; PANAS: Positive and Negative Afect Schedule; PHI: Pemberton Happiness Index; SHS: Subjective Happiness Scale; SlAs: Standardized linear analog scale; SPANE: Scale of Positive and Negative Experience; SWLS: Satisfaction With Life Scale; SWS: Subjective Well-being Scale; VAS: Visual Analog Scale-Happiness   
Psychological well-being APM: Appreciation inventory scale: present moment; COS: Compassion for Others scale; FS: Flourishing Scale; GSE: Generalised self-efcacy scale; HFS: Happiness Flourishing Scale; MHC-SF pwb: Mental Health Continuum Short Form—psychological well-being subscale; MLQP: Meaning in Life Questionnaire—presence subscale; OTH: Orientations to Happiness Questionnaire; PCQ: PsyCap Questionnaire; PPTI: Positive Psychotherapy Inventory; PIL: Purpose In Life Test; PWBS: Psychological Well-Being Scales; RAW: Resilience at Work; SWS: Subjective Well-being Scale pwb subscale   
Depression BDI: Beck Depression Index; CES-D: Center for Epidemiological Studies—Depression scale; DASS-21: Depression Anxiety Stress Scale; HADS-D: Hospital Anxiety and Depression Scale, depression; HRSD: Hamilton Rating Scale for Depression; QIDS-SR: 16-item Quick Inventory of Depressive Symptomatology; SCL-90R: Symptom Checklist-90 Revised   
Anxiety BAI: Beck Anxiety Inventory; DASS-21: Depression Anxiety Stress Scales; HADS-A: Hospital Anxiety and Depression Scale, anxiety; SCL-90R: Symptom Checklist-90 Revised; STAI: State-Trait Anxiety Inventory   
Stress DASS-21: Depression Anxiety Stress Scale; DTS: Distress Tolerance Scale; PSS- Perceived Stress Scale; SUDS: Subjective Units of Distress scale; SWSS: Stress Warning Signals Scale

# Appendix 3

See Table 6.

Table 6 Outcomes of moderator analyses   

<html><body><table><tr><td>Outcome</td><td>Criteria</td><td>Value</td><td>N</td><td>Hedge&#x27;s g (95% CI)</td><td></td><td>1</td><td>Z</td></tr><tr><td>Subjective well-being</td><td>Population</td><td>Clinical</td><td>21</td><td>0.33</td><td>(0.10-0.56)ns</td><td>82.41</td><td>2.83</td></tr><tr><td></td><td></td><td>Non-clinical</td><td>18</td><td>0.34</td><td>(0.11-0.57)ns</td><td>78.35</td><td>2.94</td></tr><tr><td></td><td>Intervention PPI</td><td></td><td>34</td><td>0.37</td><td>(0.20-0.55)ns</td><td>80.22</td><td>4.01</td></tr><tr><td></td><td></td><td>PPI+other</td><td>5</td><td>0.11</td><td>(- 0.33 to 0.55)ns</td><td>83.82</td><td>0.48</td></tr><tr><td></td><td>Delivery</td><td>Group</td><td>19</td><td>0.50</td><td>(0.26-0.74)ns</td><td>83.91</td><td>4.11</td></tr><tr><td></td><td></td><td>Individual</td><td>3</td><td>0.26</td><td>(-0.37 to 0.88)ns</td><td>0.00</td><td>0.81</td></tr><tr><td></td><td></td><td>Self-help</td><td>17</td><td>0.12</td><td>(-0.03 to 0.43)ns</td><td>76.79</td><td>1.67</td></tr><tr><td></td><td>Control</td><td>Active</td><td></td><td>0.38</td><td>(0.12-0.63)ns</td><td>84.47</td><td>2.84</td></tr><tr><td></td><td></td><td>Non-active</td><td>22</td><td>0.31</td><td>(0.11-0.52)ns</td><td>75.62</td><td>3.01</td></tr><tr><td></td><td>Sessions</td><td>≤8 sessions</td><td>9</td><td>0.54</td><td>(0.21-0.87)ns</td><td>91.77</td><td>3.21</td></tr><tr><td></td><td></td><td>&gt;8 sessions</td><td>30</td><td>0.28</td><td>(0.09-0.46)ns</td><td>67.03</td><td>2.95</td></tr><tr><td></td><td>Duration</td><td>≤8 weeks</td><td>26</td><td>0.48</td><td>(0.21-0.75)ns</td><td>89.43</td><td>3.47</td></tr><tr><td></td><td></td><td>&gt;8 weeks</td><td>13</td><td>0.26</td><td>(0.06-0.46)ns</td><td>67.33</td><td>2.51</td></tr><tr><td></td><td>Quality</td><td>High</td><td>11</td><td>0.30</td><td>(-0.03 to 0.54)ns</td><td>75.13</td><td>1.78</td></tr><tr><td></td><td></td><td>Moderate</td><td>15</td><td>0.25</td><td>(-0.01 to 0.52)ns</td><td>76.32</td><td>3.51</td></tr><tr><td></td><td></td><td>Low</td><td>13</td><td>0.55</td><td>(0.25-0.86)ns</td><td>85.88</td><td>1.67</td></tr><tr><td></td><td>Region</td><td>Western</td><td>30</td><td>0.25</td><td>(0.07-0.43)ns</td><td>82.53</td><td>3.81</td></tr><tr><td>Psychological well-</td><td></td><td>Non-western</td><td>9</td><td>0.70</td><td>(0.34-1.07)ns</td><td>79.46</td><td>2.75</td></tr><tr><td>being</td><td>Population</td><td>Clinical</td><td>6</td><td>0.35</td><td>(-0.02 to 0.71)ns</td><td>47.48</td><td>1.88</td></tr><tr><td></td><td></td><td>Non-clinical</td><td>18</td><td>0.40</td><td>(0.22-0.58)ns</td><td>81.56</td><td>4.40</td></tr><tr><td></td><td>Intervention PPI</td><td></td><td>18</td><td>0.34</td><td>(0.15-0.52)ns</td><td>78.09</td><td>3.58</td></tr><tr><td></td><td></td><td>PPI + other</td><td>6</td><td>0.55</td><td>(0.23-0.87)ns</td><td>76.49</td><td>3.39</td></tr><tr><td></td><td>Delivery</td><td>Group</td><td>12</td><td>0.38</td><td>(0.14-0.62)ns</td><td>61.56</td><td>3.06</td></tr><tr><td></td><td></td><td>Individual</td><td>1</td><td>0.83</td><td>(-0.25 to 1.91)ns</td><td>0.000</td><td>1.51</td></tr><tr><td></td><td></td><td>Self-help</td><td>11</td><td>0.38</td><td>(0.17-0.59)ns</td><td>85.19</td><td>3.55</td></tr><tr><td></td><td>Control</td><td>Active</td><td>11</td><td>0.18</td><td>(-0.04 to 0.40)ns</td><td>58.11</td><td>1.62</td></tr><tr><td></td><td></td><td>Non-active</td><td>13</td><td>0.53</td><td>(0.34-0.72)ns</td><td>76.84</td><td>5.54</td></tr><tr><td></td><td>Sessions</td><td>≤8 sessions</td><td>7</td><td>0.08</td><td>(-0.19 to 0.35)ns</td><td>46.20</td><td>0.61</td></tr><tr><td></td><td></td><td>&gt;8 sessions</td><td>17</td><td>0.50</td><td>(0.33-0.71)ns</td><td>75.49</td><td>5.75</td></tr><tr><td></td><td>Duration</td><td>≤8 weeks</td><td>9</td><td>0.20</td><td>(- 0.05 to 0.45)ns</td><td>73.70</td><td>1.60</td></tr><tr><td></td><td></td><td>&gt;8 weeks</td><td>15</td><td>0.50</td><td>(0.31-0.72)ns</td><td>77.55</td><td>5.00</td></tr><tr><td></td><td>Quality</td><td>High</td><td>8</td><td>0.24</td><td>(0.02-0.47)ns</td><td>35.67</td><td>2.09</td></tr><tr><td></td><td></td><td>Medium</td><td>7</td><td>0.63</td><td>(0.31-0.95)ns</td><td>19.82</td><td>3.87</td></tr><tr><td></td><td></td><td>Low</td><td>9</td><td>0.42</td><td>(0.15-0.68)ns</td><td>28.39</td><td>3.09</td></tr><tr><td></td><td>Region</td><td>Western</td><td>18</td><td>0.32</td><td>(0.15-0.44)ns</td><td>73.63</td><td>3.76</td></tr><tr><td></td><td></td><td>Non-western</td><td>6</td><td>0.64</td><td>(0.31-0.98)ns</td><td>79.82</td><td>3.75</td></tr></table></body></html>

Table 6 (continued)   

<html><body><table><tr><td>Outcome</td><td>Criteria</td><td>Value</td><td>N</td><td>Hedge&#x27;s g (95% CI)</td><td></td><td>1²</td><td>Z</td></tr><tr><td>Depression</td><td>Population</td><td>Clinical</td><td>21</td><td>0.27</td><td>(0.07-0.47)ns</td><td>48.67</td><td>2.64</td></tr><tr><td></td><td></td><td>Non-clinical</td><td>10</td><td>0.34</td><td>(0.08-0.60)ns</td><td>90.25</td><td>2.57</td></tr><tr><td></td><td>Intervention PPI</td><td></td><td>29</td><td>0.27</td><td>(0.11-0.43)ns</td><td>76.53</td><td>3.37</td></tr><tr><td></td><td></td><td>PPI + other</td><td>2</td><td>0.52</td><td>(-0.02 to 1.05)ns</td><td>72.53</td><td>1.90</td></tr><tr><td></td><td></td><td>PPT</td><td>1</td><td>0.47</td><td>(-0.46 to 1.39)ns</td><td>0.00</td><td>0.99</td></tr><tr><td></td><td>Delivery</td><td>Group</td><td>17</td><td>0.38</td><td>(0.16-0.60)ns</td><td>81.23</td><td>3.43</td></tr><tr><td></td><td></td><td>Individual</td><td>3</td><td>0.40</td><td>(- 0.17 to 0.97)ns</td><td>77.18</td><td>1.39</td></tr><tr><td></td><td></td><td>Self-help</td><td>11</td><td>0.17</td><td>(-0.06 to 0.40)ns</td><td>62.38</td><td>1.44</td></tr><tr><td></td><td>Control</td><td>Active</td><td>17</td><td>0.13</td><td>(-0.08 to 0.34)ns</td><td>41.32</td><td>1.20</td></tr><tr><td></td><td></td><td>Non-active</td><td>14</td><td>0.46</td><td>(0.25-0.66)ns</td><td>84.29</td><td>4.28</td></tr><tr><td></td><td>Sessions</td><td>≤8 sessions</td><td>24</td><td>0.26</td><td>(-0.09 to 0.60)ns</td><td>68.66</td><td>1.47</td></tr><tr><td></td><td></td><td>&gt;8 sessions</td><td>7</td><td>0.31</td><td>(0.13-0.49)ns</td><td>77.98</td><td>3.36</td></tr><tr><td></td><td>Duration</td><td>≤8 weeks</td><td>20</td><td>0.37</td><td>(0.18-0.56)ns</td><td>62.42</td><td>3.84</td></tr><tr><td></td><td></td><td>&gt;8 weeks</td><td>11</td><td>0.15</td><td>(-0.11 to 0.41)ns</td><td>79.52</td><td>1.11</td></tr><tr><td></td><td>Quality</td><td>High</td><td>9</td><td>0.22</td><td>(0.00-0.45)**</td><td>72.30</td><td>1.94</td></tr><tr><td></td><td></td><td>Moderate</td><td>12</td><td>0.06</td><td>(-0.16 to 0.29)ns</td><td>0.00</td><td>0.55</td></tr><tr><td></td><td></td><td>Low</td><td>10</td><td>0.75</td><td>(0.47-1.04)***</td><td>84.46</td><td>5.15</td></tr><tr><td></td><td>Region</td><td>Western</td><td>23</td><td>0.13</td><td>(0.41-1.03)*</td><td>87.68</td><td>4.57</td></tr><tr><td></td><td></td><td>Non-western</td><td>8</td><td>0.65</td><td>(0.01-0.32)***</td><td>56.00</td><td>2.10</td></tr><tr><td>Anxiety</td><td>Population</td><td>Clinical</td><td>7</td><td>0.27</td><td>(0.13-0.40)ns</td><td>0.00</td><td>3.85</td></tr><tr><td></td><td></td><td>Non-clinical</td><td>4</td><td>0.49</td><td>(0.32-0.70)ns</td><td>34.08</td><td>5.90</td></tr><tr><td></td><td>Intervention</td><td>PPI</td><td>7</td><td>0.36</td><td>(0.22-0.50)ns</td><td>11.92</td><td>0.00</td></tr><tr><td></td><td></td><td>PPI +other</td><td>4</td><td>0.29</td><td>(-0.06 to 0.65)ns</td><td>0.00</td><td>0.11</td></tr><tr><td></td><td>Delivery</td><td>Group</td><td>6</td><td>0.40</td><td>(0.15-0.44)ns</td><td>38.24</td><td>4.19</td></tr><tr><td></td><td></td><td>Individual</td><td>1</td><td>0.16</td><td>(0.31-0.98)ns</td><td>0.00</td><td>0.35</td></tr><tr><td></td><td></td><td>Self-help</td><td>4</td><td>0.32</td><td>(0.07-0.47)ns</td><td>0.00</td><td>3.47</td></tr><tr><td></td><td>Control</td><td>Active</td><td>6</td><td>0.21</td><td>(0.01-0.41)ns</td><td>0.00</td><td>2.09</td></tr><tr><td></td><td></td><td>Non-active</td><td>5</td><td>0.42</td><td>(0.29-0.54)ns</td><td>26.90</td><td>6.54</td></tr><tr><td></td><td>Sessions</td><td>≤8 sessions</td><td>2</td><td>0.05</td><td>(- 0.29 to 3.97)ns</td><td>0.07</td><td>0.31</td></tr><tr><td></td><td></td><td>&gt;8 sessions</td><td>9</td><td>0.39</td><td>(0.28-0.50)ns</td><td>8.72</td><td>6.98</td></tr><tr><td></td><td>Duration</td><td>≤8 weeks</td><td>4</td><td>0.21</td><td>(0.05-0.37)ns</td><td>0.00</td><td>2.50</td></tr><tr><td></td><td></td><td>&gt;8 weeks</td><td>7</td><td>0.47</td><td>(0.33-0.61)ns</td><td>0.00</td><td>6.71</td></tr><tr><td></td><td>Quality</td><td>High</td><td>4</td><td>0.40</td><td>(0.27-0.53)ns</td><td>37.00</td><td>5.86</td></tr><tr><td></td><td></td><td>Moderate</td><td>2</td><td>0.20</td><td>(0.00-0.40)ns</td><td>0.00</td><td>3.21</td></tr><tr><td></td><td></td><td>Low</td><td>5</td><td>0.55</td><td>(0.21-0.89)ns</td><td>0.00</td><td>1.91</td></tr><tr><td></td><td>Region</td><td>Western</td><td>2</td><td>0.42</td><td>(0.11-0.74)ns</td><td>0.00</td><td>2.65</td></tr><tr><td></td><td></td><td>Non-western</td><td>9</td><td>0.34</td><td>(0.20-0.48)ns</td><td>28.19</td><td>4.72</td></tr></table></body></html>

Table 6 (continued)   

<html><body><table><tr><td>Outcome</td><td>Criteria</td><td>Value</td><td>N</td><td>Hedge&#x27;s g</td><td>(95% CI)</td><td>1</td><td>Z</td></tr><tr><td>Stress</td><td>Population</td><td>Clinical</td><td>3</td><td>-0.09</td><td>(-0.52 to 0.36)ns</td><td>73.26</td><td>-0.55</td></tr><tr><td></td><td></td><td>Non-clinical</td><td>5</td><td>0.53</td><td>(0.35-0.71)ns</td><td>37.59</td><td>3.29</td></tr><tr><td></td><td>Intervention</td><td>PPI</td><td>6</td><td>0.18</td><td>(-0.19 to 0.54)ns</td><td>64.85</td><td>0.95</td></tr><tr><td></td><td></td><td>PPI+other</td><td>2</td><td>0.82</td><td>(0.21-1.41)ns</td><td>12.49</td><td>2.66</td></tr><tr><td></td><td>Delivery</td><td>Group</td><td>4</td><td>0.17</td><td>(- 0.32 to 0.67)ns</td><td>79.62</td><td>0.69</td></tr><tr><td></td><td></td><td>Individual</td><td>1</td><td>0.07</td><td>(- 1.07 to 1.20)ns</td><td>0.00</td><td>0.11</td></tr><tr><td></td><td></td><td>Self-help</td><td>3</td><td>0.56</td><td>(0.06-1.05)ns</td><td>0.00</td><td>2.20</td></tr><tr><td></td><td>Control</td><td>Active</td><td>4</td><td>-0.08</td><td>(-0.53 to 0.37)ns</td><td>60.75</td><td>-0.34</td></tr><tr><td></td><td></td><td>Non-active</td><td>4</td><td>0.16</td><td>(0.29-0.93)ns</td><td>34.65</td><td>3.69</td></tr><tr><td></td><td>Sessions</td><td>≤8 sessions</td><td>3</td><td>0.60</td><td>(0.04-1.15)ns</td><td>50.39</td><td>2.12</td></tr><tr><td></td><td></td><td>&gt;8 sessions</td><td>5</td><td>0.18</td><td>(-0.24 to 0.61)ns</td><td>72.34</td><td>0.84</td></tr><tr><td></td><td>Duration</td><td>≤8 weeks</td><td>3</td><td>-0.13</td><td>(- 0.65 to 0.40)ns</td><td>73.60</td><td>-0.47</td></tr><tr><td></td><td></td><td>&gt;8 weeks</td><td>5</td><td>0.56</td><td>(0.24-0.88)ns</td><td>30.91</td><td>3.39</td></tr><tr><td></td><td>Quality</td><td>High</td><td>3</td><td>0.53</td><td>(0.27-0.80)ns</td><td>20.09</td><td>3.99</td></tr><tr><td></td><td></td><td>Moderate</td><td>4</td><td>0.38</td><td>(-0.01 to 0.77)ns</td><td>37.16</td><td>1.90</td></tr><tr><td></td><td></td><td>Low</td><td>1</td><td>-1.28</td><td>(- 2.30 to -0.26)ns</td><td>0.00</td><td>-2.46</td></tr><tr><td></td><td>Region</td><td>Western</td><td>2</td><td>-0.14</td><td>(-0.78 to 0.51)ns</td><td>89.46</td><td>-0.41</td></tr><tr><td></td><td></td><td>Non-western</td><td>6</td><td>0.50</td><td>(0.13-0.87)ns</td><td>21.28</td><td>2.67</td></tr></table></body></html>

ns non-signifcant $^ { * } p < 0 . 0 5$ ; $^ { * * } p < 0 . 0 1$ ; $^ { * * * } p < 0 . 0 0 1$

# References

# \*Studies preceded by an asterisk were included in the systematic review and meta‑analysis

Adams-Huet, B., & Ahn, C. (2009). Bridging clinical investigators and statisticians. Journal of Investigative Medicine, 57(8), 818–824.   
Alden, L. E., & Trew, J. L. (2013). If it makes you happy: Engaging in kind acts increases positive afect in socially anxious individuals. Emotion, 13(1), 64–75.   
\*Antoine, P., Dauvier, B., Andreotti, E., & Congard, A. (2018). Individual diferences in the efects of a positive psychology intervention: Applied psychology. Personality and Individual Diferences, 122, 140–147.   
\*Asgharipoor, N., Farid, A. A., Arshadi, H., & Sahebi, A. (2012). A comparative study on the efectiveness of positive psychotherapy and group cognitive-behavioral therapy for the patients sufering from major depressive disorder. Iranian Journal of Psychiatry and Behavioral Sciences, 6(2), 33–41.   
\*Asl, S. T. S., Sadeghi, K., Bakhtiari, M., Ahmadi, S. M., Anamagh, A. N., & Khayatan, T. (2016). Efect of group positive psychotherapy on improvement of life satisfaction and the quality of life in infertile woman. International Journal of Fertility and Sterility, 10(1), 105–112.   
\*Asl, S. T. S., Sadeghi, K., Bakhtiari, M., Khazaie, H., Rezaei, M., & Ahmadi, S. M. (2014). The efectiveness of group positive psychotherapy on improving the depression and increasing the happiness of the infertile women: Clinical trial. European Journal of Experimental Biology, 4(3), 269–275.   
\*Bolier, L., Haverman, M., Kramer, J., Westerhof, G. J., Riper, H., Walburg, J. A., et  al. (2013a). An Internet-based intervention to promote mental ftness for mildly depressed adults: Randomized controlled trial. Journal of Medical Internet Research, 15(9), 209–226.   
Bolier, L., Haverman, M., Westerhof, G. J., Riper, H., Smit, F., & Bohlmeijer, E. T. (2013b). Positive psychology interventions: A meta-analysis of randomized controlled studies. BMC Public Health, 13, 119.   
Buchanan, K. E., & Bardi, A. (2010). Acts of kindness and acts of novelty afect life satisfaction. Journal of Social Psychology, 150, 235–237.   
Button, K. S., Ioannidis, J. P., Mokrysz, C., Nosek, B. A., Flint, J., Robinson, E. S., et al. (2013). Power failure: Why small sample size undermines the reliability of neuroscience. Nature Reviews Neuroscience, 14(5), 365–376.   
\*Cantarella, A., Borella, E., Marigo, C., & De Beni, R. (2017). Benefts of well-being training in healthy older adults. Applied Psychology: Health and Well-Being, 9(3), 261–284.   
\*Carr, A., & Finnegan, L. (2015). The say ‘yes’ to life (SYTL) program: A positive psychology group intervention for depression. Journal of Contemporary Psychotherapy, 45(2), 109–118.   
Casellas-Grau, A., Font, A., & Vives, J. (2014). Positive psychology interventions in breast cancer. A systematic review. Psychooncology, 23, 9–19.   
\*Celano, C. M., Beale, E. E., Mastromauro, C. A., Stewart, J. G., Millstein, R. A., Auerbach, R. P., et  al. (2017). Psychological interventions to reduce suicidality in high-risk patients with major depression: A randomized controlled trial. Psychological Medicine, 47(5), 810–821.   
\*Cerezo, M. V., Ortiz-Tallo, M., Cardenal, V., & De La Torre-Luque, A. (2014). Positive psychology group intervention for breast cancer patients: A randomised trial. Psychological Reports, 115(1), 44–64.   
Chakhssi, F., Kraiss, J. T., Sommers-Spijkerman, M., & Bohlmeijjer, E. T. (2018). The efect of positive psychology interventions on well-being in clinical populations: A systematic review and meta-analysis. BMC Psychiatry, 18(1), 211.   
Chan, A. W., Tetzlaf, J. M., Gøtzsche, P. C., Altman, D. G., Mann, H., Berlin, J. A., et al. (2013). SPIRIT 2013 explanation and elaboration: Guidance for protocols of clinical trials. BMJ, 346, e7586.   
\*Chaves, C., Lopez-Gomez, I., Hervas, G., & Vazquez, C. (2017). A comparative study on the efcacy of a positive psychology intervention and a cognitive behavioral therapy for clinical depression. Cognitive Therapy and Research, 41(3), 417–433.   
\*Cheung, E. O., Cohn, M. A., Dunn, L. B., Melisko, M. E., Morgan, S., Penedo, F. J., et  al. (2017). A randomized pilot trial of a positive afect skill intervention (lessons in linking afect and coping) for women with metastatic breast cancer. Psycho-Oncology, 26(12), 2101–2108.   
\*Cohn, M. A., Pietrucha, M. E., Saslow, L. R., Hult, J. R., & Moskowitz, J. T. (2014). An online positive afect skills intervention reduces depression in adults with type 2 diabetes. The Journal of Positive Psychology, 9(6), 523–534.   
Cuijpers, P. (2016). Meta-analyses in mental health research. A practical guide. Amsterdam: Vrije Universiteit Amsterdam.   
\*Cullen, B., Pownall, J., Cummings, J., Baylan, S., Broomfeld, N., Haig, C., et al. (2016). Positive PsychoTherapy in ABI Rehab (PoPsTAR): A pilot randomised controlled trial. Neuropsychological Rehabilitation, 28(1), 17–33.   
DeSteno, D., Li, Y., Dickens, L., & Lerner, J. S. (2015). Gratitude: A tool for reducing economic impatience. Psychological Science, 25(6), 1262–1267.   
Dickens, L. R. (2017). Using gratitude to promote positive change: A series of meta-analyses investigating the efectiveness of gratitude interventions. Basic and Applied Social Psychology, 39(4), 193–208.   
Diener, E. (2009). The science of well-being: The collected works of Ed Diener (Vol. 37). Berlin: Springer.   
Digdon, N., & Koble, A. (2011). Efects of constructive worry, imagery distraction, and gratitude interventions on sleep quality: A pilot trial. Applied Psychology: Health and Well-Being, 3(2), 193–206.   
Donaldson, S. I., Dollwet, M., & Rao, M. A. (2015). Happiness, excellence, and optimal human functioning revisited: Examining the peer-reviewed literature linked to positive psychology. The Journal of Positive Psychology, 10(3), 185–195.   
\*Dowlatabadi, M. M., Ahmadi, S. M., Sorbi, M. H., Beiki, O., Razavi, T. K., & Bidaki, R. (2016). The efectiveness of group positive psychotherapy on depression and happiness in breast cancer patients: A randomized controlled trial. Electronic Physician, 8(3), 2175.   
\*Drozd, F., Mork, L., Nielsen, B., Raeder, S., & Bjørkli, C. A. (2014a). Better days—A randomized controlled trial of an internet-based positive psychology intervention. The Journal of Positive Psychology, 9(5), 377–388.   
\*Drozd, F., Skeie, L. G., Kraft, P., & Kvale, D. (2014b). A web-based intervention trial for depressive symptoms and subjective well-being in patients with chronic HIV infection. AIDS Care, 26(9), 1080–1089.   
Duval, S., & Tweedie, R. (2000). Trim and fll: A simple funnel-plot-based method of testing and adjusting for publication bias in meta-analysis. Biometrics, 56(2), 455–463.   
\*Dyrbye, L. N., West, C. P., Richards, M. L., Ross, H. J., Satele, D., & Shanafelt, T. D. (2016). A randomized, controlled study of an online intervention to promote job satisfaction and well-being among physicians. Burnout Research, 3(3), 69–75.   
Egger, M., Smith, G. D., Schneider, M., & Minder, C. (1997). Bias in meta-analysis detected by a simple, graphical test. BMJ, 315(7109), 629–634.   
\*Feicht, T., Wittmann, M., Jose, G., Mock, A., Hirschhausen, E.von, & Esch, T. (2013). Evaluation of a seven-week web-based happiness training to improve psychological well-being, reduce stress, and enhance mindfulness and fourishing: A randomized controlled occupational health study. EvidenceBased Complementary and Alternative Medicine. Article ID 676953.   
Froh, J. J. (2004). The history of positive psychology: Truth be told. NYS Psychologist, 16(3), 18–20.   
Gable, S. L., & Haidt, J. (2005). What (and why) is positive psychology? Review of General Psychology, 9(2), 103–110.   
\*Gelfn, M., Zohar, A. H., & Lev-Ari, L. (2018). Personality change and therapeutic gain: Randomized controlled trial of a positive psychology intervention. International Journal of Psychology and Psychological Therapy, 18(2), 193–205.   
Gosling, S. D., Sandy, C. J., John, O. P., & Potter, J. (2010). Wired but not WEIRD: The promise of the internet in reaching more diverse samples. Behavioral and Brain Sciences, 33(2–3), 94–95.   
\*Guo, Y.-F., Zhang, X., Plummer, V., Lam, L., Cross, W., & Zhang, J.-P. (2016). Positive psychotherapy for depression and self-efcacy in undergraduate nursing students: A randomized, controlled trial. International Journal of Mental Health Nursing, 26(4), 375–383.   
Hart, K. E., & Sasso, T. (2011). Mapping the contours of contemporary positive psychology. Canadian Psychology, 52(2), 2–92.   
\*Hausmann, L. R., Youk, A., Kwoh, C. K., Ibrahim, S. A., Hannon, M. J., Weiner, D. K., et al. (2017). Testing a positive psychological intervention for osteoarthritis. Pain Medicine, 18(10), 1908–1920.   
\*Hendriks, T. (2018). Positive psychology interventions in a multi-ethnic and cross-cultural context. Doctoral dissertation. Amsterdam: University of Amsterdam. http://www.uva.nl/en/profle/h/e/t.hendr iks2/t.hendriks2.html.   
Hendriks, T., Schotanus-Dijkstra, M., Hassankhan, A., Graafsma, T., Bohlmeijer, E. T., & de Jong, J. (2018a). The efcacy of non-Western positive psychology interventions: a meta-analysis and systematic review. International Journal of Wellbeing, 8(1), 71–98.   
Hendriks, T., Warren, M. A., Schotanus-Dijkstra, M., Hassankhan, A., Graafsma, T., Bohlmeijer, E. T., et al. (2018b). How WEIRD are positive psychology interventions? A bibliometric analysis of randomized controlled trials on the science of well-being. The Journal of Positive Psychology, 1, 1–13.   
Higgins, J. P. T., Altman, D. G., Gøtzsche, P. C., Jüni, P., Moher, D., Oxman, A. D., et  al. (2011). The Cochrane Collaboration’s tool for assessing risk of bias in randomized trials. BMJ, 343, d5928.   
Higgins, J. P., & Green, S. (2011). Cochrane handbook for systematic reviews of interventions (Vol. 4). New York: Wiley.   
Higgins, J., & Thompson, S. G. (2002). Quantifying heterogeneity in a meta-analysis. Statistics in Medicine, 21(11), 1539–1558.   
\*Hufman, J. C., Mastromauro, C. A., Boehm, J. K., Seabrook, R., Fricchione, G. L., Denninger, J. W., et al. (2011). Development of a positive psychology intervention for patients with acute cardiovascular disease. Heart International, 6(e13), 47–54.   
\*Hwang, K., Kwon, A., & Hong, C. (2016). A preliminary study of new positive psychology interventions: Neurofeedback-aided meditation therapy and modifed positive psychotherapy. Current Psychology, 36(3), 683–695.   
Isik, S., & Erguner-Tekinalp, B. (2017). The efects of gratitude journaling on Turkish frst year college students’ college adjustment, life satisfaction and positive afect. International Journal for the Advancement of Counselling, 39(2), 164–175.   
\*Ivtzan, I., Young, T., Martman, J., Jefrey, A., Lomas, T., Hart, R., & Eiroa-Orosa, F. J. (2016). Integrating mindfulness into positive psychology: A randomised controlled trial of an online positive mindfulness program. Mindfulness, 7(6), 1396–1407.   
\*Ivtzan, I., Young, T., Lee, H. C., Lomas, T., Daukantaitė, D., & Kjell, O. N. (2018). Mindfulness based fourishing program: A cross-cultural study of Hong Kong Chinese and British participants. Journal of Happiness Studies, 19(8), 2205–2223.   
\*Joutsenniemi, K., Kaattari, C., Härkänen, T., Pankakoski, M., Langinvainio, H., Lönnqvist, J., et al. (2014). E-mail-based exercises in happiness, physical activity and readings: A randomized trial on 3274 Finns. Journal of Psychiatry, 17(6), 1000140.   
\*Kahler, C. W., Spillane, N. S., Day, A. M., Cioe, P. A., Parks, A., Leventhal, A. M., et  al. (2015). Positive psychotherapy for smoking cessation: A pilot randomized controlled trial. Nicotine & Tobacco Research, 17, 1385–1392.   
\*Khayatan, T., Azkhosh, M., Bahmani, B., Azimian, M., & Dolatshahi, B. (2014). Group positive psychotherapy and depression of females afected by multiple sclerosis. Iranian Rehabilitation Journal, 12(22), 49–53.   
Kim, H., Doiron, K. M., Warren, M. A., & Donaldson, S. I. (2018). The international landscape of positive psychology research: A systematic review. International Journal of Wellbeing, 8(1), 50–70.   
\*Koydemir, S., & Sun-Selisik, Z. (2016). Well-being on campus: Testing the efectiveness of an online strengths-based intervention for frst year college students. British Journal of Guidance & Counselling, 44(4), 434–446.   
Lau, R. W., & Cheng, S. T. (2011). Gratitude lessens death anxiety. European Journal of Ageing, 8(3), 169–175.   
Linley, P. A., & Joseph, S. (2004). Applied positive psychology: A new perspective for professional practice. In P. A. Linley & S. Joseph (Eds.), Positive psychology in practise (pp. 3–14). New Jersey: Wiley.   
Linley, P. A., Joseph, S., Harrington, S., & Wood, A. M. (2006). Positive psychology: Past, present, and (possible) future. The Journal of Positive Psychology, 1(1), 3–16.   
Lipsey, M. W., & Wilson, D. B. (1993). The efcacy of psychological, educational, and behavioral treatment: Confrmation from meta-analysis. American Psychologist, 48, 1181–1209.   
\*Lü, W., Whang, Z., & Liu, Y. (2013). A pilot study on changes of cardiac vagal tone in individuals with low trait positive afect: The efect of positive psychotherapy. International Journal of Psychophysiology, 88, 213–217.   
\*Luthans, F., Avey, J. B., Avolio, B. J., & Peterson, S. J. (2010). The development and resulting performance impact of positive psychological capital. Human Resource Development Quarterly, 21, 41–67.   
\*Luthans, F., Avey, J. B., & Patera, J. L. (2008). Experimental analysis of a web-based training intervention to develop positive psychological capital. Academy of Management Learning & Education, 7(2), 209–221.   
Macaskill, A. (2016). Review of positive psychology applications in clinical medical populations. Healthcare, 4, 66.   
\*Mohammadi, N., Aghayousef, A., Nikrahan, G. R., Adams, C. N., Alipour, A., Sadeghi, M., et al. (2018). A randomized trial of an optimism training intervention in patients with heart disease. General Hospital Psychiatry, 51, 46–53.   
Moher, D., Liberati, A., Teztlaf, J., & Altman, D. G. (2009). The PRISMA group. Preferred reporting items for systematic reviews and meta-analyses: The PRISMA statement. Annals of Internal Medicine, 51, 1–7.   
Moher, D., Hopewell, S., Schulz, K. F., Montori, V., Gøtzsche, P. C., Devereaux, P. J., et al. (2010). CONSORT 2010 explanation and elaboration: updated guidelines for reporting parallel group randomized trials. BMJ, 340, c869.   
\*Moskowitz, J. T., Carrico, A. W., Duncan, L. G., Cohn, M. A., Cheung, E. O., Batchelder, A., et al. (2017). Randomized controlled trial of a positive afect intervention for people newly diagnosed with HIV. Journal of Consulting and Clinical Psychology, 85(5), 409.   
\*Müller, R., Gertz, K. J., Molton, I. R., Terrill, A. L., Bombardier, C. H., Ehde, D. M., et al. (2016). Efects of a tailored positive psychology intervention on well-being and pain in individuals with chronic pain and a physical disability: A feasibility trial. The Clinical Journal of Pain, 32(1), 32–44.   
\*Myers, N. D., Prilleltensky, I., Prilleltensky, O., McMahon, A., Dietz, S., & Rubenstein, C. L. (2017). Efcacy of the fun for wellness online intervention to promote multidimensional well-being: A randomized controlled trial. Prevention Science, 18(8), 984–994.   
Myers, N. D., Dietz, S., Prilleltensky, I., Prilleltensky, O., McMahon, A., Rubenstein, C. L., & Lee, S. (2018). Efcacy of the fun for wellness online intervention to promote well-being actions: A secondary data analysis. Games for Health Journal, 7(4), 225–239.   
\*Neumeier, L. M., Brook, L., Ditchburn, G., & Sckopke, P. (2017). Delivering your daily dose of well-being to the workplace: A randomized controlled trial of an online well-being programme for employees. European Journal of Work and Organizational Psychology, 26(4), 555–573.   
\*Nikrahan, G. R., Laferton, J. A., Asgari, K., Kalantari, M., Abedi, M. R., Etesampour, A., et  al. (2016). Efects of positive psychology interventions on risk biomarkers in coronary patients: A randomized, wait-list controlled pilot trial. Psychosomatics: Journal of Consultation and Liaison Psychiatry, 57(4), 359–368.   
O’Connell, B. H., O’Shea, D., & Gallagher, S. (2016). Enhancing social relationships through positive psychology activities: A randomised controlled trial. The Journal of Positive Psychology, 11(2), 149–162. 389   
Orwin, R. G. (1983). A fail-safe N for efect size in meta-analysis. Journal of Educational Statistics, 8(2), 157–159.   
\*Page, K. M., & Vella-Brodrick, D. A. (2013). The working for wellness program: RCT of an employee well-being intervention. Journal of Happiness Studies, 14(3), 1007–1031.   
Parks, A. C., & Biswas-Diener, R. (2013). Positive interventions: Past, present and future. In T. B. Kashdan & J. V. Ciarrochi (Eds.), Mindfulness, acceptance, and positive psychology: The seven foundations of well-being. Oakland, CA: New Harbinger Publications.   
\*Peters, M. L., Smeets, E., Feijge, M., van Breukelen, G., Andersson, G., Buhrman, M., et  al. (2017). Happy despite pain: A randomized controlled trial of an 8-week internet-delivered positive psychology intervention for enhancing well-being in patients with chronic pain. The Clinical Journal of Pain, 33, 962–975.   
Proyer, R. T., Gander, F., Wellenzohn, S., & Ruch, W. (2015). Strengths-based positive psychology interventions: A randomized placebo-controlled online trial on long-term efects for a signature strengths-vs a lesser strengths-intervention. Frontiers in Psychology, 6, 456.   
\*Proyer, R. T., Gander, F., Wellenzohn, S., & Ruch, W. (2016). Addressing the role of personality, ability, and positive and negative afect in positive psychology interventions: Findings from a randomized intervention based on the Authentic Happiness Theory and extensions. The Journal of Positive Psychology, 11(6), 609–621.   
Rashid, T. (2015). Positive psychotherapy: A strength-based approach. The Journal of Positive Psychology, 10(1), 25–40.   
\*Roepke, A. M., Jafeem, S. R., Rife, O. M., McGonigal, J., Broome, R., & Maxwell, B. (2015). Randomized controlled trial of SuperBetter, a smartphone-based/internet-based self-help tool to reduce depressive symptoms. Games for Health Journal: Research, Development, and Clinical Applications, 4(3), 235–246.   
\*Rogerson, S., Meir, R., Crowley-McHattan, Z., McEwen, K., & Pastoors, R. (2016). A randomized controlled pilot trial investigating the impact of a workplace resilience program during a time of signifcant organizational change. Journal of Occupational and Environmental Medicine, 58(4), 329–334.   
Rosenberg, M. S. (2005). The fle-drawer problem revisited: A general weighted method for calculating fail-safe numbers in meta-analysis. Evolution, 59(2), 464–468.   
Rusk, R. D., Vella-Brodrick, D. A., & Waters, L. (2018). A complex dynamic systems approach to lasting positive change: The synergistic change model. The Journal of Positive Psychology, 13(4), 406–418.   
Rusk, R. D., & Waters, L. E. (2013). Tracing the size, reach, impact, and breadth of positive psychology. The Journal of Positive Psychology, 8(3), 207–221.   
\*Sanjuan, P., Montalbetti, T., Perez-Garcia, A. M., Bermudez, J., Arranz, H., & Castro, A. (2016). A randomised trial of a positive intervention to promote well-being in cardiac patients. Applied Psychology: Health and Well-Being, 8(1), 64–84.   
\*Schotanus-Dijkstra, M., Drossaert, C. H., Pieterse, M. E., Boon, B., Walburg, J. A., & Bohlmeijer, E. T. (2017). An early intervention to promote well-being and fourishing and reduce anxiety and depression: A randomized controlled trial. Internet Interventions, 9, 15–24.   
\*Schueller, M. S., & Parks, A. C. (2012). Disseminating self-help: Positive psychology exercises in an online trial. Journal of Medical Internet Research, 14, e63.   
Schueller, S. M., & Parks, A. C. (2014). The science of self-help. European Psychologist, 19(2), 145–155.   
Seligman, M. (2018). PERMA and the building blocks of well-being. The Journal of Positive Psychology, 13(4), 333–335.   
Seligman, M. E. P., & Csikszentmihalyi, M. (2000). Positive psychology: An introduction. American Psychologist, 55, 5–14.   
\*Seligman, M. E. P., Rashid, T., & Parks, A. C. (2006). Positive psychotherapy. American Psychologist, 61(8), 774–788.   
Seligman, M. E. P., Steen, T. A., Park, N., & Peterson, C. (2005). Positive psychology progress: Empirical validation of interventions. American Psychologist, 60(5), 410.   
Sheldon, K. M., & Kasser, T. (2001). Goals, congruence, and positive well-being: New empirical support for humanistic theories. Journal of Humanistic Psychology, 41(1), 30–50.   
Sheldon, K. M., & King, L. (2001). Why positive psychology is necessary. American Psychologist, 56(3), 216–217.   
Sin, N. L., & Lyubomirsky, S. (2009). Enhancing well-being and alleviating depressive symptoms with positive psychology interventions: A practice-friendly meta-analysis. Journal of Clinical Psychology, 65, 467–487.   
Slavin, R., & Smith, D. (2009). The relationship between sample sizes and efect sizes in systematic reviews in education. Educational Evaluation and Policy Analysis, 31(4), 500–506.   
Sterne, J. A., Egger, M., & Moher, D. (2008). Addressing reporting biases. In J. P. T. Higgins & S. Green (Eds.), Cochrane handbook for systematic reviews of interventions: Cochrane book series (pp. 297–333).   
Sutipan, P., Intarakamhang, U., & Macaskill, A. (2016). The impact of positive psychological interventions on well-being in healthy elderly people. Journal of Happiness Studies, 25, 1–23.   
Toback, R. L., Graham-Bermann, S. A., & Patel, P. D. (2016). Outcomes of a character strengths–based intervention on self-esteem and self-efcacy of psychiatrically hospitalized Youths. Psychiatric Service, 67, 574–577.   
\*Uliaszek, A. A., Rashid, T., Williams, G. E., & Gulamani, T. (2016). Group therapy for university students: A randomized control trial of dialectical behavior therapy and positive psychotherapy. Behaviour Research and Therapy, 77, 78–85.   
Walsh, S., Cassidy, M., & Priebe, S. (2017). The application of positive psychotherapy in mental health care: A systematic review. Journal of Clinical Psychology, 73(6), 638–651.   
Weiss, L. A., Westerhof, G. J., & Bohlmeijer, E. T. (2016). Can we increase psychological well-being? The efects of interventions on psychological well-being: A meta-analysis of randomized controlled trials. PLoS ONE, 11(6), e0158092.   
Woodworth, R. J., O’Brien-Malone, A., Diamond, M. R., & Schuz, B. (2016). Happy days: Positive psychology interventions efects on afect in an N-of-1 trial. International Journal of Clinical and Health Psychology, 16(1), 21–29.   
Yelland, L. N., Sullivan, T. R., Voysey, M., Lee, K. J., Cook, J. A., & Forbes, A. B. (2015). Applying the intention-to-treat principle in practice: Guidance on handling randomisation errors. Clinical Trials, 12(4), 418–423.   
Zhang, Z., Xu, X., & Ni, H. (2013). Small studies may overestimate the efect sizes in critical care metaanalyses: A meta-epidemiological study. Critical Care, 17(1), R2.

Publisher’s Note Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional afliations.

# Afliations

# Tom Hendriks1 $\textcircled { \scriptsize { 1 } }$ · Marijke Schotanus‑Dijkstra2  · Aabidien Hassankhan1  · Joop de Jong3  · Ernst Bohlmeijer2